/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.item.tool;

import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.item.JerotesItemThrowUse;
import com.jerotes.jerotesvillage.entity.Shoot.ThrowingBall.BaseThrowingBallEntity;
import com.jerotes.jerotesvillage.entity.Shoot.ThrowingBall.ThrowingStubbornStoneEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageEnchantments;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillagePotions;
import com.jerotes.jerotesvillage.item.PotionThrowingBall;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class ItemToolBaseThrowingBall
extends Item
implements JerotesItemThrowUse {
    private final int effectLevel;
    private final float baseDamage;
    private final float addDamage;

    public ItemToolBaseThrowingBall(Item.Properties properties, int effectLevel, float baseDamage, float addDamage) {
        super(properties);
        this.effectLevel = effectLevel;
        this.baseDamage = baseDamage;
        this.addDamage = addDamage;
    }

    public boolean getOffHandItem(LivingEntity livingEntity) {
        InventoryEntity inventoryEntity;
        return livingEntity instanceof InventoryEntity && (inventoryEntity = (InventoryEntity)livingEntity).canUseThrow() && livingEntity.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof FireworkRocketItem;
    }

    public void addEffects(LivingEntity livingEntity) {
        if (!livingEntity.m_9236_().f_46443_) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.THROWING_STUBBORN_STONE.get(), 5, this.effectLevel - 1, false, false));
        }
    }

    public boolean isJerotesThrow() {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_41720_() instanceof PotionThrowingBall && interactionHand == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() instanceof PotionItem && PotionUtils.m_43579_((ItemStack)player.m_21206_()) != JerotesVillagePotions.WASTE.get() && PotionUtils.m_43579_((ItemStack)player.m_21206_()) != PotionUtils.m_43579_((ItemStack)itemStack)) {
            PotionUtils.m_43549_((ItemStack)itemStack, (Potion)PotionUtils.m_43579_((ItemStack)player.m_21206_()));
            if (!player.m_150110_().f_35937_) {
                PotionUtils.m_43549_((ItemStack)player.m_21206_(), (Potion)((Potion)JerotesVillagePotions.WASTE.get()));
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11772_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12313_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        if (!level.f_46443_) {
            Projectile throwItem = this.useJerotesThrowShoot((LivingEntity)player, interactionHand);
            throwItem.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.useJerotesThrowShootSpeed((LivingEntity)player, interactionHand), 1.0f);
            level.m_7967_((Entity)throwItem);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    public Projectile useJerotesThrowShoot(LivingEntity livingEntity, InteractionHand interactionHand) {
        Item item = livingEntity.m_21120_(interactionHand).m_41720_();
        if (item instanceof ItemToolBaseThrowingBall) {
            ItemToolBaseThrowingBall itemToolBaseThrowingBall = (ItemToolBaseThrowingBall)item;
            if (!livingEntity.m_9236_().m_5776_()) {
                BaseThrowingBallEntity throwItem = itemToolBaseThrowingBall.throwingBall(livingEntity.m_9236_(), livingEntity);
                throwItem.m_37446_(livingEntity.m_21120_(interactionHand));
                if (livingEntity.m_21051_(Attributes.f_22279_) != null) {
                    throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 15.0;
                    if (livingEntity.m_20142_()) {
                        throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 30.0;
                    } else if (livingEntity.m_6144_()) {
                        throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 7.5;
                    }
                }
                double deltaMoveX = livingEntity.m_20184_().m_7096_();
                double deltaMoveY = livingEntity.m_20184_().m_7098_();
                double deltaMoveZ = livingEntity.m_20184_().m_7094_();
                if (livingEntity.m_20184_().m_7096_() < 0.0) {
                    deltaMoveX = -livingEntity.m_20184_().m_7096_();
                }
                if (livingEntity.m_20184_().m_7098_() < 0.0) {
                    deltaMoveY = -livingEntity.m_20184_().m_7098_();
                }
                if (livingEntity.m_20184_().m_7094_() < 0.0) {
                    deltaMoveZ = -livingEntity.m_20184_().m_7094_();
                }
                throwItem.deltaMoveDamage = deltaMoveX + deltaMoveY + deltaMoveZ;
                throwItem.addMaxBackCount = livingEntity.m_21120_(interactionHand).getEnchantmentLevel((Enchantment)JerotesVillageEnchantments.ELASTICITY.get());
                if (interactionHand == InteractionHand.MAIN_HAND && livingEntity.m_21206_().m_41720_() instanceof FireworkRocketItem) {
                    if (!livingEntity.m_20067_()) {
                        livingEntity.m_9236_().m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11933_, SoundSource.NEUTRAL, 0.5f, 0.4f / (livingEntity.m_217043_().m_188501_() * 0.4f + 0.8f));
                    }
                    throwItem.m_37446_(livingEntity.m_21206_());
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        if (!player.m_150110_().f_35937_) {
                            player.m_21206_().m_41774_(1);
                        }
                    }
                } else if (interactionHand == InteractionHand.OFF_HAND && livingEntity.m_21205_().m_41720_() instanceof FireworkRocketItem) {
                    if (!livingEntity.m_20067_()) {
                        livingEntity.m_9236_().m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11933_, SoundSource.NEUTRAL, 0.5f, 0.4f / (livingEntity.m_217043_().m_188501_() * 0.4f + 0.8f));
                    }
                    throwItem.m_37446_(livingEntity.m_21205_());
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        if (!player.m_150110_().f_35937_) {
                            player.m_21205_().m_41774_(1);
                        }
                    }
                }
                return throwItem;
            }
        }
        return null;
    }

    public float useJerotesThrowShootSpeed(LivingEntity livingEntity, InteractionHand interactionHand) {
        Item item = livingEntity.m_21120_(interactionHand).m_41720_();
        if (item instanceof ItemToolBaseThrowingBall) {
            ItemToolBaseThrowingBall itemToolBaseThrowingBall = (ItemToolBaseThrowingBall)item;
            if (!livingEntity.m_9236_().m_5776_()) {
                BaseThrowingBallEntity throwItem = itemToolBaseThrowingBall.throwingBall(livingEntity.m_9236_(), livingEntity);
                throwItem.m_37446_(livingEntity.m_21120_(interactionHand));
                double attackofspeeds = 0.0;
                if (livingEntity.m_21051_(Attributes.f_22279_) != null) {
                    attackofspeeds = livingEntity.m_21133_(Attributes.f_22279_) * 5.0;
                    throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 15.0;
                    if (livingEntity.m_20142_()) {
                        attackofspeeds = livingEntity.m_21133_(Attributes.f_22279_) * 10.0;
                        throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 30.0;
                    } else if (livingEntity.m_6144_()) {
                        attackofspeeds = livingEntity.m_21133_(Attributes.f_22279_) * 2.0;
                        throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 7.5;
                    }
                }
                double deltaMoveX = livingEntity.m_20184_().m_7096_();
                double deltaMoveY = livingEntity.m_20184_().m_7098_();
                double deltaMoveZ = livingEntity.m_20184_().m_7094_();
                if (livingEntity.m_20184_().m_7096_() < 0.0) {
                    deltaMoveX = -livingEntity.m_20184_().m_7096_();
                }
                if (livingEntity.m_20184_().m_7098_() < 0.0) {
                    deltaMoveY = -livingEntity.m_20184_().m_7098_();
                }
                if (livingEntity.m_20184_().m_7094_() < 0.0) {
                    deltaMoveZ = -livingEntity.m_20184_().m_7094_();
                }
                throwItem.deltaMoveDamage = deltaMoveX + deltaMoveY + deltaMoveZ;
                throwItem.addMaxBackCount = livingEntity.m_21120_(interactionHand).getEnchantmentLevel((Enchantment)JerotesVillageEnchantments.ELASTICITY.get());
                double deltaMove = livingEntity.m_20184_().m_7096_() + livingEntity.m_20184_().m_7098_() + livingEntity.m_20184_().m_7094_();
                return (float)((double)0.6f + attackofspeeds + deltaMove);
            }
        }
        return 1.6f;
    }

    public BaseThrowingBallEntity throwingBall(Level level, LivingEntity livingEntity) {
        return new ThrowingStubbornStoneEntity(level, livingEntity);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237110_((String)"item.jerotesvillage.throwing_ball", (Object[])new Object[]{this.effectLevel, Float.valueOf(this.baseDamage), Float.valueOf(this.addDamage)}).m_130940_(ChatFormatting.YELLOW));
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }
}

