/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.item.tool;

import com.jerotes.jerotes.entity.CatchEntity;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.item.ItemCatchBase;
import com.jerotes.jerotes.item.JerotesItemThrowUse;
import com.jerotes.jerotesvillage.entity.Shoot.ThrowingBall.BaseThrowingBallEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageEnchantments;
import com.jerotes.jerotesvillage.item.tool.ItemToolBaseThrowingBall;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemToolBaseThrowingBallGlove
extends Item
implements JerotesItemThrowUse {
    private final float addSpeed;

    public ItemToolBaseThrowingBallGlove(Item.Properties properties, float addSpeed) {
        super(properties);
        this.addSpeed = addSpeed;
    }

    public boolean getOffHandItem(LivingEntity livingEntity) {
        InventoryEntity inventoryEntity;
        return livingEntity instanceof InventoryEntity && (inventoryEntity = (InventoryEntity)livingEntity).canUseThrow() && livingEntity.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof ItemToolBaseThrowingBall;
    }

    public float getAddSpeed() {
        return this.addSpeed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isJerotesThrow(LivingEntity livingEntity) {
        Item item = livingEntity.m_21205_().m_41720_();
        if (!(item instanceof ItemToolBaseThrowingBallGlove)) return false;
        ItemToolBaseThrowingBallGlove itemToolBaseThrowingBallGlove = (ItemToolBaseThrowingBallGlove)item;
        item = livingEntity.m_21206_().m_41720_();
        if (!(item instanceof ItemToolBaseThrowingBall)) return false;
        ItemToolBaseThrowingBall itemToolBaseThrowingBall = (ItemToolBaseThrowingBall)item;
        return true;
    }

    public boolean isJerotesThrowShrinkSelf() {
        return false;
    }

    public boolean isJerotesThrowShrinkOther() {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        if (interactionHand == InteractionHand.MAIN_HAND && (player.m_21206_().m_41720_() instanceof ItemToolBaseThrowingBall || player.m_21206_().m_41720_() instanceof ItemCatchBase)) {
            ItemStack itemStack = player.m_21120_(interactionHand);
            ItemStack throwingBall = player.m_21206_();
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12313_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
            Item item = throwingBall.m_41720_();
            if (!(item instanceof ItemCatchBase)) {
                if (!level.f_46443_) {
                    Projectile throwItem = this.useJerotesThrowShoot((LivingEntity)player, interactionHand);
                    throwItem.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.useJerotesThrowShootSpeed((LivingEntity)player, interactionHand), 1.0f);
                    level.m_7967_((Entity)throwItem);
                }
            } else {
                ItemCatchBase itemCatchBase = (ItemCatchBase)item;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EntityType entityType = itemCatchBase.getEntityType();
                    Entity entity = entityType.m_20592_(serverLevel, throwingBall, null, player.m_20097_().m_7494_(), MobSpawnType.BUCKET, true, false);
                    if (entity instanceof CatchEntity) {
                        CatchEntity catchEntity = (CatchEntity)entity;
                        catchEntity.loadFromCatchTag(throwingBall.m_41784_());
                        catchEntity.setFromCatch(true);
                        entity.m_20219_(player.m_146892_());
                        entity.m_146926_(player.m_146909_());
                        entity.m_146922_(player.m_146908_());
                        entity.m_5616_(player.m_6080_());
                        entity.m_5618_(player.f_20883_);
                        float f = player.m_146908_();
                        float f2 = player.m_146909_();
                        float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
                        float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
                        float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
                        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
                        float f7 = 1.5f;
                        entity.m_6853_(false);
                        entity.m_20256_(entity.m_20184_().m_82520_((double)(f3 *= f7 / f6 * 2.0f), (double)(f4 *= f7 / f6 * 2.0f), (double)(f5 *= f7 / f6 * 2.0f)));
                    }
                    serverLevel.m_142346_((Entity)player, GameEvent.f_157810_, player.m_20097_().m_7494_());
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)player.m_21206_().m_41720_()));
            if (!player.m_150110_().f_35937_) {
                throwingBall.m_41774_(1);
            }
            itemStack.m_41622_(1, (LivingEntity)player, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, interactionHand);
    }

    public Projectile useJerotesThrowShoot(LivingEntity livingEntity, InteractionHand interactionHand) {
        Item item = livingEntity.m_21205_().m_41720_();
        if (item instanceof ItemToolBaseThrowingBallGlove) {
            ItemToolBaseThrowingBallGlove itemToolBaseThrowingBallGlove = (ItemToolBaseThrowingBallGlove)item;
            item = livingEntity.m_21206_().m_41720_();
            if (item instanceof ItemToolBaseThrowingBall) {
                ItemToolBaseThrowingBall itemToolBaseThrowingBall = (ItemToolBaseThrowingBall)item;
                if (!livingEntity.m_9236_().m_5776_()) {
                    BaseThrowingBallEntity throwItem = itemToolBaseThrowingBall.throwingBall(livingEntity.m_9236_(), livingEntity);
                    throwItem.m_37446_(livingEntity.m_21206_());
                    if (livingEntity.m_21051_(Attributes.f_22279_) != null) {
                        float add = itemToolBaseThrowingBallGlove.getAddSpeed();
                        if (livingEntity.m_21051_(Attributes.f_22279_) != null) {
                            throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 15.0 * (double)add;
                            if (livingEntity.m_20142_()) {
                                throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 30.0 * (double)add;
                            } else if (livingEntity.m_6144_()) {
                                throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 7.5 * (double)add;
                            }
                        }
                    }
                    double deltaMoveX = livingEntity.m_20184_().m_7096_();
                    double deltaMoveY = livingEntity.m_20184_().m_7098_();
                    double deltaMoveZ = livingEntity.m_20184_().m_7094_();
                    if (livingEntity.m_20184_().m_7096_() < 0.0) {
                        deltaMoveX = -livingEntity.m_20184_().m_7096_();
                    }
                    if (livingEntity.m_20184_().m_7098_() < 0.0) {
                        deltaMoveY = -livingEntity.m_20184_().m_7098_();
                    }
                    if (livingEntity.m_20184_().m_7094_() < 0.0) {
                        deltaMoveZ = -livingEntity.m_20184_().m_7094_();
                    }
                    throwItem.deltaMoveDamage = deltaMoveX + deltaMoveY + deltaMoveZ;
                    throwItem.addMaxBackCount = livingEntity.m_21205_().getEnchantmentLevel((Enchantment)JerotesVillageEnchantments.ELASTICITY.get()) + livingEntity.m_21206_().getEnchantmentLevel((Enchantment)JerotesVillageEnchantments.ELASTICITY.get());
                    return throwItem;
                }
            }
        }
        return null;
    }

    public float useJerotesThrowShootSpeed(LivingEntity livingEntity, InteractionHand interactionHand) {
        Item item = livingEntity.m_21205_().m_41720_();
        if (item instanceof ItemToolBaseThrowingBallGlove) {
            ItemToolBaseThrowingBallGlove itemToolBaseThrowingBallGlove = (ItemToolBaseThrowingBallGlove)item;
            item = livingEntity.m_21206_().m_41720_();
            if (item instanceof ItemToolBaseThrowingBall) {
                ItemToolBaseThrowingBall itemToolBaseThrowingBall = (ItemToolBaseThrowingBall)item;
                if (!livingEntity.m_9236_().m_5776_()) {
                    BaseThrowingBallEntity throwItem = itemToolBaseThrowingBall.throwingBall(livingEntity.m_9236_(), livingEntity);
                    throwItem.m_37446_(livingEntity.m_21206_());
                    float add = itemToolBaseThrowingBallGlove.getAddSpeed();
                    double attackofspeeds = 0.0;
                    if (livingEntity.m_21051_(Attributes.f_22279_) != null) {
                        attackofspeeds = livingEntity.m_21133_(Attributes.f_22279_) * 5.0 * (double)add;
                        throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 15.0 * (double)add;
                        if (livingEntity.m_20142_()) {
                            attackofspeeds = livingEntity.m_21133_(Attributes.f_22279_) * 10.0 * (double)add;
                            throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 30.0 * (double)add;
                        } else if (livingEntity.m_6144_()) {
                            attackofspeeds = livingEntity.m_21133_(Attributes.f_22279_) * 2.0 * (double)add;
                            throwItem.speedDamage = livingEntity.m_21133_(Attributes.f_22279_) * 7.5 * (double)add;
                        }
                    }
                    double deltaMoveX = livingEntity.m_20184_().m_7096_();
                    double deltaMoveY = livingEntity.m_20184_().m_7098_();
                    double deltaMoveZ = livingEntity.m_20184_().m_7094_();
                    if (livingEntity.m_20184_().m_7096_() < 0.0) {
                        deltaMoveX = -livingEntity.m_20184_().m_7096_();
                    }
                    if (livingEntity.m_20184_().m_7098_() < 0.0) {
                        deltaMoveY = -livingEntity.m_20184_().m_7098_();
                    }
                    if (livingEntity.m_20184_().m_7094_() < 0.0) {
                        deltaMoveZ = -livingEntity.m_20184_().m_7094_();
                    }
                    throwItem.deltaMoveDamage = deltaMoveX + deltaMoveY + deltaMoveZ;
                    throwItem.addMaxBackCount = livingEntity.m_21205_().getEnchantmentLevel((Enchantment)JerotesVillageEnchantments.ELASTICITY.get()) + livingEntity.m_21206_().getEnchantmentLevel((Enchantment)JerotesVillageEnchantments.ELASTICITY.get());
                    double deltaMove = livingEntity.m_20184_().m_7096_() + livingEntity.m_20184_().m_7098_() + livingEntity.m_20184_().m_7094_();
                    return (float)((double)0.6f + attackofspeeds + deltaMove);
                }
            }
        }
        return 1.6f;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237110_((String)"item.jerotesvillage.throwing_ball_glove", (Object[])new Object[]{Float.valueOf(this.addSpeed)}).m_130940_(ChatFormatting.YELLOW));
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }
}

