/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.mixin;

import com.jerotes.jerotesvillage.entity.in.GoastEntity;
import com.jerotes.jerotesvillage.event.WorldEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    protected LivingEntityMixin(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"shouldDropExperience"}, at={@At(value="HEAD")}, cancellable=true)
    public void shouldDropExperience(CallbackInfoReturnable<Boolean> cir) {
        if (WorldEvent.ZsieinModerateInfectedAbove(this.m_9236_())) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    public boolean canAddPassengerJerotes(Entity entity) {
        return this.m_7310_(entity);
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    public void checkFallDamage(double d, boolean bl, BlockState blockState, BlockPos blockPos, CallbackInfo ci) {
        LivingEntity living = (LivingEntity)this;
        if (!this.m_9236_().f_46443_ && this.f_19789_ > 1.5f && bl && !blockState.m_60795_()) {
            boolean boot;
            boolean bl2 = boot = living.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_BOOTS.get();
            if (boot) {
                OtherSpellFind.EarthquakeKick(living, 6, 3, 0, 1800, false);
            }
        }
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    public void heal(float f, CallbackInfo ci) {
        if (WorldEvent.ZsieinSevereInfectedAbove(this.m_9236_()) && !OtherEntityFactionFind.isZsiein(this.m_6095_())) {
            ci.cancel();
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(DamageSource damageSource, float p_21017_, CallbackInfoReturnable<Boolean> cir) {
        GoastEntity goastEntity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof GoastEntity && (goastEntity = (GoastEntity)((Object)livingEntityMixin)).isGoast() && damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);
}

