/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.navigation;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrightLandBeastPathNavigation
extends GroundPathNavigation {
    public BrightLandBeastPathNavigation(Mob mob, Level level) {
        super(mob, level);
    }

    @NotNull
    protected PathFinder m_5532_(int maxVisitedNodes) {
        this.f_26508_ = new WalkNodeEvaluator(){

            public BlockPathTypes m_8086_(BlockGetter level, int x, int y, int z) {
                return BlockPathTypes.WALKABLE;
            }
        };
        return new PathFinder(this.f_26508_, maxVisitedNodes);
    }

    protected void m_7636_() {
        boolean flag;
        Vec3 vec3 = this.m_7475_();
        float entityWidth = this.f_26494_.m_20205_();
        this.f_26505_ = Math.max(0.5f, entityWidth * 0.75f);
        BlockPos vec3i = this.f_26496_.m_77400_();
        Vec3 targetCenter = new Vec3((double)vec3i.m_123341_() + 0.5, (double)vec3i.m_123342_(), (double)vec3i.m_123343_() + 0.5);
        AABB entityBox = this.f_26494_.m_20191_();
        double dx = Math.max(0.0, Math.max(entityBox.f_82288_ - targetCenter.f_82479_, targetCenter.f_82479_ - entityBox.f_82291_));
        double dz = Math.max(0.0, Math.max(entityBox.f_82290_ - targetCenter.f_82481_, targetCenter.f_82481_ - entityBox.f_82293_));
        boolean bl = flag = dx <= (double)this.f_26505_ && dz <= (double)this.f_26505_ || dx * dx + dz * dz <= (double)(this.f_26505_ * this.f_26505_);
        if (flag || this.m_264193_(this.f_26496_.m_77401_().f_77282_) && this.m_26559_(vec3)) {
            this.f_26496_.m_77374_();
        }
        this.m_6481_(vec3);
    }

    @Nullable
    public Path createPathForLargeEntity(BlockPos target, int range, float entityWidth) {
        HashSet<BlockPos> expandedTargets = new HashSet<BlockPos>();
        int radius = (int)Math.ceil(entityWidth / 2.0f);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                expandedTargets.add(target.m_7918_(dx, 0, dz));
            }
        }
        return this.m_26548_(expandedTargets, range);
    }

    private boolean m_26559_(Vec3 p_26560_) {
        boolean flag1;
        if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
            return false;
        }
        Vec3 vec3 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
        if (!p_26560_.m_82509_((Position)vec3, 2.0)) {
            return false;
        }
        if (this.m_183431_(p_26560_, this.f_26496_.m_77380_((Entity)this.f_26494_))) {
            return true;
        }
        Vec3 vec31 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + 1));
        Vec3 vec32 = vec3.m_82546_(p_26560_);
        Vec3 vec33 = vec31.m_82546_(p_26560_);
        double d0 = vec32.m_82556_();
        double d1 = vec33.m_82556_();
        boolean flag = d1 < d0;
        boolean bl = flag1 = d0 < 0.5;
        if (!flag && !flag1) {
            return false;
        }
        Vec3 vec34 = vec32.m_82541_();
        Vec3 vec35 = vec33.m_82541_();
        return vec35.m_82526_(vec34) < 0.0;
    }
}

