/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.network;

import com.jerotes.jerotesvillage.block.BitterCold.TorchOfFirmIce;
import com.jerotes.jerotesvillage.block.BitterCold.TorchOfFirmIceEntity;
import com.jerotes.jerotesvillage.client.gui.TorchOfFirmIceScreen;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class TorchOfFirmIcePacket {
    public int elite;
    public BlockPos blockPos;
    public boolean open;
    public int count;

    public TorchOfFirmIcePacket(int id, BlockPos blockPos, boolean open, int count) {
        this.elite = id;
        this.blockPos = blockPos;
        this.open = open;
        this.count = count;
    }

    public static void encode(TorchOfFirmIcePacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.elite);
        buffer.m_130064_(packet.blockPos);
        buffer.writeBoolean(packet.open);
        buffer.writeInt(packet.elite);
    }

    public static TorchOfFirmIcePacket decode(FriendlyByteBuf buffer) {
        return new TorchOfFirmIcePacket(buffer.readInt(), buffer.m_130135_(), buffer.readBoolean(), buffer.readInt());
    }

    public static void consume(TorchOfFirmIcePacket message, Supplier<NetworkEvent.Context> context) {
        Level level;
        Block block;
        ServerPlayer playerEntity = context.get().getSender();
        if (playerEntity != null && (block = (level = playerEntity.m_9236_()).m_8055_(message.blockPos).m_60734_()) instanceof TorchOfFirmIce) {
            TorchOfFirmIce torchOfFirmIce = (TorchOfFirmIce)block;
            if (message.open) {
                ServerLevel serverLevel;
                if (level instanceof ServerLevel && TorchOfFirmIceScreen.canSummonFindBlockCount(message.elite, serverLevel = (ServerLevel)level, message.blockPos, (Player)playerEntity)) {
                    torchOfFirmIce.setOpen((Entity)playerEntity, level, level.m_8055_(message.blockPos), message.blockPos, true);
                    BlockEntity blockentity = level.m_7702_(message.blockPos);
                    if (blockentity instanceof TorchOfFirmIceEntity) {
                        TorchOfFirmIceEntity torchOfFirmIceEntity = (TorchOfFirmIceEntity)blockentity;
                        torchOfFirmIceEntity.shrink(message.count);
                    }
                    TorchOfFirmIceScreen.changeEntity(message.elite, level, message.blockPos);
                }
            } else if (torchOfFirmIce.getElite(level.m_8055_(message.blockPos)) == message.elite) {
                torchOfFirmIce.setElite((Entity)playerEntity, level, level.m_8055_(message.blockPos), message.blockPos, 0);
            } else {
                torchOfFirmIce.setElite((Entity)playerEntity, level, level.m_8055_(message.blockPos), message.blockPos, message.elite);
            }
        }
        context.get().setPacketHandled(true);
    }
}

