/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageRecipeSerializers;
import com.jerotes.jerotesvillage.init.JerotesVillageRecipeType;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class HagReplacementRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> base;
    private final NonNullList<Ingredient> result;

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public HagReplacementRecipe(ResourceLocation id, NonNullList<Ingredient> base, NonNullList<Ingredient> result) {
        this.id = id;
        this.base = base;
        this.result = result;
    }

    public NonNullList<Ingredient> getBase() {
        return this.base;
    }

    public NonNullList<Ingredient> getResult() {
        return this.result;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ((Ingredient)this.result.get(0)).m_43908_()[0];
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ((Ingredient)this.result.get(0)).m_43908_()[0];
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)JerotesVillageRecipeSerializers.HAG_REPLACEMENT.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)JerotesVillageRecipeType.HAG_REPLACEMENT.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)JerotesVillageItems.NEW_HAGS_CAULDRON.get());
    }

    public static class HagReplacementSerializer
    implements RecipeSerializer<HagReplacementRecipe> {
        public HagReplacementRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            NonNullList<Ingredient> baseIn = HagReplacementSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"base"));
            NonNullList<Ingredient> resultIn = HagReplacementSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"result"));
            return new HagReplacementRecipe(resourceLocation, baseIn, resultIn);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public HagReplacementRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            int baseSize = friendlyByteBuf.m_130242_();
            NonNullList base = NonNullList.m_122780_((int)baseSize, (Object)Ingredient.f_43901_);
            for (int j = 0; j < baseSize; ++j) {
                base.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            }
            int resultSize = friendlyByteBuf.m_130242_();
            NonNullList result = NonNullList.m_122780_((int)resultSize, (Object)Ingredient.f_43901_);
            for (int j = 0; j < resultSize; ++j) {
                result.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            }
            return new HagReplacementRecipe(resourceLocation, (NonNullList<Ingredient>)base, (NonNullList<Ingredient>)result);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, HagReplacementRecipe recipe) {
            friendlyByteBuf.m_130130_(recipe.base.size());
            for (Ingredient ingredient : recipe.base) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.m_130130_(recipe.result.size());
            for (Ingredient ingredient : recipe.result) {
                ingredient.m_43923_(friendlyByteBuf);
            }
        }
    }
}

