/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageRecipeSerializers;
import com.jerotes.jerotesvillage.init.JerotesVillageRecipeType;
import com.jerotes.jerotesvillage.recipes.TabletPressingCraftingBookCategory;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TabletPressingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> base;
    private final NonNullList<Ingredient> addition;
    private final ItemStack result;
    private final TabletPressingCraftingBookCategory category;

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public TabletPressingRecipe(ResourceLocation id, NonNullList<Ingredient> base, NonNullList<Ingredient> addition, ItemStack result, TabletPressingCraftingBookCategory category) {
        this.id = id;
        this.base = base;
        this.addition = addition;
        this.result = result;
        this.category = category;
    }

    public NonNullList<Ingredient> getAddition() {
        return this.addition;
    }

    public NonNullList<Ingredient> getBase() {
        return this.base;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList combined = NonNullList.m_122779_();
        combined.addAll(this.base);
        combined.addAll(this.addition);
        return combined;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)JerotesVillageRecipeType.TABLET_PRESSING.get();
    }

    @Nullable
    public TabletPressingCraftingBookCategory category() {
        return this.category;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_BLOCK_PHYSICIAN.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)JerotesVillageRecipeSerializers.TABLET_PRESSING.get();
    }

    public static class TabletPressingSerializer
    implements RecipeSerializer<TabletPressingRecipe> {
        public TabletPressingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            NonNullList<Ingredient> baseIn = TabletPressingSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"base"));
            NonNullList<Ingredient> additionIn = TabletPressingSerializer.readIngredients(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            TabletPressingCraftingBookCategory tabletPressingCraftingBookCategory = (TabletPressingCraftingBookCategory)TabletPressingCraftingBookCategory.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)jsonObject, (String)"category", (String)null), (Enum)TabletPressingCraftingBookCategory.MISC);
            return new TabletPressingRecipe(resourceLocation, baseIn, additionIn, itemstack, tabletPressingCraftingBookCategory);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public TabletPressingRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            int baseSize = friendlyByteBuf.m_130242_();
            NonNullList base = NonNullList.m_122780_((int)baseSize, (Object)Ingredient.f_43901_);
            for (int j = 0; j < baseSize; ++j) {
                base.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            }
            int additionSize = friendlyByteBuf.m_130242_();
            NonNullList addition = NonNullList.m_122780_((int)additionSize, (Object)Ingredient.f_43901_);
            for (int j = 0; j < additionSize; ++j) {
                addition.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            }
            ItemStack result = friendlyByteBuf.m_130267_();
            TabletPressingCraftingBookCategory category = TabletPressingCraftingBookCategory.valueOf(friendlyByteBuf.m_130277_());
            return new TabletPressingRecipe(resourceLocation, (NonNullList<Ingredient>)base, (NonNullList<Ingredient>)addition, result, category);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, TabletPressingRecipe recipe) {
            friendlyByteBuf.m_130130_(recipe.base.size());
            for (Ingredient ingredient : recipe.base) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.m_130130_(recipe.addition.size());
            for (Ingredient ingredient : recipe.addition) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.m_130055_(recipe.result);
            friendlyByteBuf.m_130070_(recipe.category.name());
        }
    }
}

