/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.spell;

import com.jerotes.jerotes.spell.MagicSpell;
import com.jerotes.jerotes.spell.MagicType;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Boss.Biome.GemstoneMalignasaurEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.Botanize.CoilvineBotanizeEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.Bulge.SeawaveEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.FlyingFireball.FlyingFireballEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.IronTeeth.IronTeethEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.VinePodBomb.VinePodBombEntity;
import com.jerotes.jerotesvillage.entity.Other.BitterColdAltarEntity;
import com.jerotes.jerotesvillage.entity.Other.CogonSwordEntity;
import com.jerotes.jerotesvillage.entity.Other.PurpleSandPhantomEntity;
import com.jerotes.jerotesvillage.entity.Other.ThornSpikeEntity;
import com.jerotes.jerotesvillage.entity.Other.UncleanTentacleEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;

public class OtherSpellList {
    public static MagicSpell CorrosiverBreath(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "corrosiver_breath", (ParticleOptions)JerotesVillageParticleTypes.CORROSIVER_BREATH_DISPLAY.get(), JerotesVillageSounds.MAGIC_CORROSIVER_BREATH){

            public boolean spellFindUse() {
                return OtherSpellFind.CorrosiverBreath(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellLevel(), this.getSpellLevel(), this.getSpellLevel(), this.getSpellLevel(), this.getSpellAccuracy(), this.getSpellLevel(), 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell SedimentMissile(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "sediment_missile", (ParticleOptions)JerotesVillageParticleTypes.SEDIMENT_MISSILE_DISPLAY.get(), JerotesVillageSounds.MAGIC_SEDIMENT_MISSILE){

            public boolean spellFindUse() {
                return OtherSpellFind.SedimentMissile(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellAccuracy(), 1, 1.0f, 3 + this.getSpellLevel(), this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public boolean canUseTargetNone() {
                return true;
            }
        };
    }

    public static MagicSpell OceanCurrentBreath(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "ocean_current_breath", (ParticleOptions)JerotesVillageParticleTypes.OCEAN_CURRENT_BREATH_DISPLAY.get(), JerotesVillageSounds.MAGIC_OCEAN_CURRENT_BREATH){

            /*
             * Enabled aggressive block sorting
             */
            public boolean spellFindUse() {
                Object object;
                LivingEntity livingEntity = this.getCaster();
                Entity entity = this.getTarget();
                LivingEntity livingEntity2 = this.getCaster();
                if (livingEntity2 instanceof GemstoneMalignasaurEntity) {
                    GemstoneMalignasaurEntity gemstoneMalignasaur = (GemstoneMalignasaurEntity)livingEntity2;
                    if (gemstoneMalignasaur.head1 != null) {
                        object = gemstoneMalignasaur.head1;
                        return OtherSpellFind.OceanCurrentBreath(livingEntity, entity, (Entity)object, this.getSpellLevel(), this.getSpellLevel() * 3, this.getSpellLevel() - 1, this.getSpellAccuracy(), this.getSpellLevel(), 5.0f, this.getCaster() instanceof Player);
                    }
                }
                object = this.getCaster();
                return OtherSpellFind.OceanCurrentBreath(livingEntity, entity, (Entity)object, this.getSpellLevel(), this.getSpellLevel() * 3, this.getSpellLevel() - 1, this.getSpellAccuracy(), this.getSpellLevel(), 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }
        };
    }

    public static MagicSpell BloodyScream(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "bloody_scream", (ParticleOptions)JerotesVillageParticleTypes.BLOODY_SCREAM_DISPLAY.get(), JerotesVillageSounds.MAGIC_BLOODY_SCREAM){

            public boolean spellFindUse() {
                return OtherSpellFind.BloodyScream(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellLevel() * 6, this.getSpellLevel() - 1, this.getSpellAccuracy(), this.getSpellLevel() + 1, 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell PurpleSandPhantom(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "purple_sand_phantom", (ParticleOptions)JerotesVillageParticleTypes.PURPLE_SAND_PHANTOM_DISPLAY.get(), JerotesVillageSounds.MAGIC_PURPLE_SAND_PHANTOM){

            public boolean spellFindUse() {
                return OtherSpellFind.PurpleSandPhantom(this.getCaster(), this.getTarget(), this.getSpellLevel() * 2, this.getSpellLevel() * 3, 12, this.getSpellLevel());
            }

            public int baseSpellLevel() {
                return 4;
            }

            public float getSpellDistance() {
                return 32.0f;
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(PurpleSandPhantomEntity.class, this.getCaster().m_20191_().m_82377_(32.0, 32.0, 32.0));
                    list.removeIf(purpleSandPhantomEntity -> purpleSandPhantomEntity.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() <= this.getSpellLevel() * 4;
                }
                return super.canUse();
            }

            public boolean canUseTargetNone() {
                return true;
            }
        };
    }

    public static MagicSpell Whirlpool(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "whirlpool", (ParticleOptions)JerotesVillageParticleTypes.WHIRLPOOL_DISPLAY.get(), JerotesVillageSounds.MAGIC_WHIRLPOOL){

            /*
             * Enabled aggressive block sorting
             */
            public boolean spellFindUse() {
                Object object;
                LivingEntity livingEntity = this.getCaster();
                Entity entity = this.getTarget();
                LivingEntity livingEntity2 = this.getCaster();
                if (livingEntity2 instanceof GemstoneMalignasaurEntity) {
                    GemstoneMalignasaurEntity gemstoneMalignasaur = (GemstoneMalignasaurEntity)livingEntity2;
                    if (gemstoneMalignasaur.head1 != null) {
                        object = gemstoneMalignasaur.head1;
                        return OtherSpellFind.Whirlpool(livingEntity, entity, (Entity)object, this.getSpellLevel(), this.getSpellLevel(), this.getSpellAccuracy(), this.getSpellLevel(), 10.0f, this.getCaster() instanceof Player);
                    }
                }
                object = this.getCaster();
                return OtherSpellFind.Whirlpool(livingEntity, entity, (Entity)object, this.getSpellLevel(), this.getSpellLevel(), this.getSpellAccuracy(), this.getSpellLevel(), 10.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }
        };
    }

    public static MagicSpell SecondRounderAnimatedArmor(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "second_rounder_animated_armor", (ParticleOptions)JerotesVillageParticleTypes.SECOND_ROUNDER_ANIMATED_ARMOR_DISPLAY.get(), JerotesVillageSounds.MAGIC_SECOND_ROUNDER_ANIMATED_ARMOR){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.SecondRounderAnimatedArmor(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 5;
            }

            public float getSpellDistance() {
                return 6.0f;
            }

            public boolean canUseToEntity(Entity entity) {
                ArmorStand armorStand;
                ArmorStand armorStand2;
                ArmorStand armorStand3;
                ArmorStand armorStand4;
                boolean helmet = entity instanceof ArmorStand && (armorStand4 = (ArmorStand)entity).m_6844_(EquipmentSlot.HEAD).m_41619_();
                boolean chestplate = entity instanceof ArmorStand && (armorStand3 = (ArmorStand)entity).m_6844_(EquipmentSlot.CHEST).m_41619_();
                boolean leggings = entity instanceof ArmorStand && (armorStand2 = (ArmorStand)entity).m_6844_(EquipmentSlot.LEGS).m_41619_();
                boolean boots = entity instanceof ArmorStand && (armorStand = (ArmorStand)entity).m_6844_(EquipmentSlot.FEET).m_41619_();
                return entity instanceof ArmorStand && (!helmet || !chestplate || !leggings || !boots);
            }
        };
    }

    public static MagicSpell BitterColdIceSpike(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "bitter_cold_ice_spike", (ParticleOptions)JerotesVillageParticleTypes.BITTER_COLD_ICE_SPIKE_DISPLAY.get(), JerotesVillageSounds.MAGIC_BITTER_COLD_ICE_SPIKE){

            public boolean spellFindUse() {
                return OtherSpellFind.BitterColdIceSpike(this.getCaster(), this.getTarget(), this.getSpellLevel(), 7 + this.getSpellLevel() * 3, 2.25f, this.getSpellAccuracy(), 1, 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell CorrosiveIceSpike(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "corrosive_ice_spike", (ParticleOptions)JerotesVillageParticleTypes.CORROSIVE_ICE_SPIKE_DISPLAY.get(), JerotesVillageSounds.MAGIC_CORROSIVE_ICE_SPIKE){

            public boolean spellFindUse() {
                return OtherSpellFind.CorrosiveIceSpike(this.getCaster(), this.getTarget(), this.getSpellLevel(), 7 + this.getSpellLevel() * 3, 2.25f, this.getSpellAccuracy(), this.getSpellLevel(), 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell SerponFireball(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "serpon_fireball", (ParticleOptions)JerotesVillageParticleTypes.SERPON_FIREBALL_DISPLAY.get(), JerotesVillageSounds.MAGIC_SERPON_FIREBALL){

            public boolean spellFindUse() {
                return OtherSpellFind.SerponFireball(this.getCaster(), this.getTarget(), this.getSpellLevel(), 6 + this.getSpellLevel() * 3, 0.5f + (float)this.getSpellLevel() * 0.25f, this.getSpellAccuracy(), 1, 15.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell ElasticLightBall(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "elastic_light_ball", (ParticleOptions)JerotesVillageParticleTypes.ELASTIC_LIGHT_BALL_DISPLAY.get(), JerotesVillageSounds.MAGIC_ELASTIC_LIGHT_BALL){

            public boolean spellFindUse() {
                return OtherSpellFind.ElasticLightBall(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellLevel() * 6, 1, 1.6f, this.getSpellAccuracy(), this.getSpellLevel(), 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell SecreteFireOilBomb(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "secrete_fire_oil_bomb", (ParticleOptions)JerotesVillageParticleTypes.SECRETE_FIRE_OIL_BOMB_DISPLAY.get(), JerotesVillageSounds.MAGIC_SECRETE_FIRE_OIL_BOMB){

            public boolean spellFindUse() {
                return OtherSpellFind.SecreteFireOilBomb(this.getCaster(), this.getTarget(), this.getSpellLevel(), 6 + this.getSpellLevel() * 3, 0.5f + (float)this.getSpellLevel() * 0.25f, this.getSpellAccuracy(), this.getSpellLevel(), 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }
        };
    }

    public static MagicSpell PredationToothedFlowerShoot(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "predation_toothed_flower_shoot", (ParticleOptions)JerotesVillageParticleTypes.PREDATION_TOOTHED_FLOWER_SHOOT_DISPLAY.get(), JerotesVillageSounds.MAGIC_PREDATION_TOOTHED_FLOWER_SHOOT){

            public boolean spellFindUse() {
                return OtherSpellFind.PredationToothedFlowerShoot(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellAccuracy(), this.getSpellLevel(), 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell SmokeMissile(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "smoke_missile", (ParticleOptions)JerotesVillageParticleTypes.SMOKE_MISSILE_DISPLAY.get(), JerotesVillageSounds.MAGIC_SMOKE_MISSILE){

            public boolean spellFindUse() {
                return OtherSpellFind.SmokeMissile(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellLevel() * 3, 1, this.getSpellLevel() * 3, this.getSpellLevel(), this.getSpellLevel(), this.getSpellAccuracy(), 1, 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }
        };
    }

    public static MagicSpell BulgeBullet(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "bulge_bullet", (ParticleOptions)JerotesVillageParticleTypes.BULGE_BULLET_DISPLAY.get(), JerotesVillageSounds.MAGIC_BULGE_BULLET){

            public boolean spellFindUse() {
                return OtherSpellFind.BulgeBullet(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellAccuracy(), 1, 5.0f, this.getSpellLevel() * 3, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell BotanizeBullet(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "botanize_bullet", (ParticleOptions)JerotesVillageParticleTypes.BOTANIZE_BULLET_DISPLAY.get(), JerotesVillageSounds.MAGIC_BOTANIZE_BULLET){

            public boolean spellFindUse() {
                return OtherSpellFind.BotanizeBullet(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellAccuracy(), 1, 5.0f, this.getSpellLevel() * 3, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell DroughtFireball(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "drought_fireball", (ParticleOptions)JerotesVillageParticleTypes.DROUGHT_FIREBALL_DISPLAY.get(), JerotesVillageSounds.MAGIC_DROUGHT_FIREBALL){

            public boolean spellFindUse() {
                return OtherSpellFind.DroughtFireball(this.getCaster(), this.getTarget(), this.getSpellLevel(), 6 + this.getSpellLevel() * 3, this.getSpellAccuracy(), 1, 5.0f, this.getSpellLevel() * 3, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell RuinsWindCharge(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "ruins_wind_charge", (ParticleOptions)JerotesVillageParticleTypes.RUINS_WIND_CHARGE_DISPLAY.get(), JerotesVillageSounds.MAGIC_RUINS_WIND_CHARGE){

            public boolean spellFindUse() {
                return OtherSpellFind.RuinsWindCharge(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellAccuracy(), 1, 5.0f, this.getSpellLevel() * 3, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell RadiantBomb(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "radiant_bomb", (ParticleOptions)JerotesVillageParticleTypes.RADIANT_BOMB_DISPLAY.get(), JerotesVillageSounds.MAGIC_RADIANT_BOMB){

            public boolean spellFindUse() {
                return OtherSpellFind.RadiantBomb(this.getCaster(), this.getTarget(), this.getSpellLevel(), 0.5f + (float)this.getSpellLevel() * 0.25f, this.spellLevel * 6, 1, this.getSpellAccuracy(), 1, 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }
        };
    }

    public static MagicSpell ArcaneLightSpot(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "arcane_light_spot", (ParticleOptions)JerotesVillageParticleTypes.ARCANE_LIGHT_SPOT_DISPLAY.get(), JerotesVillageSounds.MAGIC_ARCANE_LIGHT_SPOT){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.ArcaneLightSpot(this.getCaster(), (Entity)((entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster()), this.getSpellLevel(), this.getSpellLevel() * 6, 1, this.getSpellAccuracy(), 1, 1.0f, 3 + this.getSpellLevel(), this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public boolean canUseTargetNone() {
                return true;
            }
        };
    }

    public static MagicSpell SerponSirocco(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "serpon_sirocco", (ParticleOptions)JerotesVillageParticleTypes.SERPON_SIROCCO_DISPLAY.get(), JerotesVillageSounds.MAGIC_SERPON_SIROCCO){

            public boolean spellFindUse() {
                return OtherSpellFind.SerponSirocco(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellLevel() * 2, this.getSpellLevel(), this.getSpellAccuracy(), this.getSpellLevel() - 2, 12.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }
        };
    }

    public static MagicSpell EyeDiscShoot(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "eye_disc_shoot", (ParticleOptions)JerotesVillageParticleTypes.EYE_DISC_SHOOT_DISPLAY.get(), JerotesVillageSounds.MAGIC_EYE_DISC_SHOOT){

            public boolean spellFindUse() {
                return OtherSpellFind.EyeDiscShoot(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellAccuracy(), 1, 5.0f, 20 + this.getSpellLevel() * 5, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell IceRockThrow(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "ice_rock_throw", (ParticleOptions)JerotesVillageParticleTypes.ICE_ROCK_THROW_DISPLAY.get(), JerotesVillageSounds.MAGIC_ICE_ROCK_THROW){

            public boolean spellFindUse() {
                return OtherSpellFind.IceRockThrow(this.getCaster(), this.getTarget(), this.getSpellLevel(), 7 + this.getSpellLevel() * 3, 1.6f, this.getSpellAccuracy(), 1, 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell BitterColdFrostbite(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "bitter_cold_frostbite", (ParticleOptions)JerotesVillageParticleTypes.BITTER_COLD_FROSTBITE_DISPLAY.get(), JerotesVillageSounds.MAGIC_BITTER_COLD_FROSTBITE){

            public boolean spellFindUse() {
                return OtherSpellFind.BitterColdFrostbite(this.getCaster(), this.getTarget(), this.getSpellLevel(), 7 + this.getSpellLevel() * 3, this.getSpellAccuracy(), this.getSpellLevel(), 2.0f, 20 + this.getSpellLevel() * 5, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell SerponFlames(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "serpon_flames", (ParticleOptions)JerotesVillageParticleTypes.SERPON_FLAMES_DISPLAY.get(), JerotesVillageSounds.MAGIC_SERPON_FLAMES){

            public boolean spellFindUse() {
                return OtherSpellFind.SerponFlames(this.getCaster(), this.getTarget(), this.getSpellLevel(), 6 + this.getSpellLevel() * 3, this.getSpellAccuracy(), this.getSpellLevel(), 2.0f, 20 + this.getSpellLevel() * 5, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell OminousFlames(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "ominous_flames", (ParticleOptions)JerotesVillageParticleTypes.OMINOUS_FLAMES_DISPLAY.get(), JerotesVillageSounds.MAGIC_OMINOUS_FLAMES){

            public boolean spellFindUse() {
                return OtherSpellFind.OminousFlames(this.getCaster(), this.getTarget(), this.getSpellLevel(), 6 + this.getSpellLevel() * 3, this.getSpellAccuracy(), this.getSpellLevel(), 2.0f, 20 + this.getSpellLevel() * 5, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }
        };
    }

    public static MagicSpell WormThunderstorm(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "worm_thunderstorm", (ParticleOptions)JerotesVillageParticleTypes.WORM_THUNDERSTORM_DISPLAY.get(), JerotesVillageSounds.MAGIC_WORM_THUNDERSTORM){

            public boolean spellFindUse() {
                return OtherSpellFind.WormThunderstorm(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellAccuracy(), 1, 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }
        };
    }

    public static MagicSpell PushForce(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "push_force", (ParticleOptions)JerotesVillageParticleTypes.PUSH_FORCE_DISPLAY.get(), JerotesVillageSounds.MAGIC_PUSH_FORCE){

            public boolean spellFindUse() {
                return OtherSpellFind.PushForce(this.getCaster(), this.getTarget(), this.getSpellLevel(), this.getSpellLevel(), 1.0f + (float)this.getSpellLevel() * 0.2f, this.getSpellLevel(), 1.0f + (float)this.getSpellLevel() * 0.2f, this.getSpellAccuracy(), 1, 5.0f, this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }
        };
    }

    public static MagicSpell AsphyxiaControl(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "asphyxia_control", (ParticleOptions)JerotesVillageParticleTypes.ASPHYXIA_CONTROL_DISPLAY.get(), JerotesVillageSounds.MAGIC_ASPHYXIA_CONTROL){

            public boolean spellFindUse() {
                return OtherSpellFind.AsphyxiaControl(this.getCaster(), this.getSpellLevel() * 6, this.getSpellLevel(), this.getSpellLevel() * 8);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }

            public float getSpellDistance() {
                return this.getSpellLevel() * 8;
            }
        };
    }

    public static MagicSpell OceanDragonDeterrence(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "ocean_dragon_deterrence", (ParticleOptions)JerotesVillageParticleTypes.OCEAN_DRAGON_DETERRENCE_DISPLAY.get(), JerotesVillageSounds.MAGIC_OCEAN_DRAGON_DETERRENCE){

            public boolean spellFindUse() {
                return OtherSpellFind.OceanDragonDeterrence(this.getCaster(), this.getSpellLevel() * 2, this.getSpellLevel() / 2 + 1, this.getSpellLevel() * 2, this.getSpellLevel() / 2 + 1, this.getSpellLevel() * 8);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }

            public float getSpellDistance() {
                return this.getSpellLevel() * 8;
            }
        };
    }

    public static MagicSpell GemstoneWaves(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "gemstone_waves", (ParticleOptions)JerotesVillageParticleTypes.GEMSTONE_WAVES_DISPLAY.get(), JerotesVillageSounds.MAGIC_GEMSTONE_WAVES){

            public boolean spellFindUse() {
                return OtherSpellFind.GemstoneWaves(this.getCaster(), this.getSpellLevel(), this.getSpellLevel() * 3, this.getSpellLevel(), 8, 30.0f, this.getSpellLevel() * 5);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return 8.0f;
            }
        };
    }

    public static MagicSpell IndomitableWill(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "indomitable_will", (ParticleOptions)JerotesVillageParticleTypes.INDOMITABLE_WILL_DISPLAY.get(), JerotesVillageSounds.MAGIC_INDOMITABLE_WILL){

            public boolean spellFindUse() {
                return OtherSpellFind.IndomitableWill(this.getCaster(), this.getSpellLevel(), this.getSpellLevel() * 4, this.getSpellLevel() * 5);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 4;
            }

            public float getSpellDistance() {
                return this.getSpellLevel() * 4;
            }
        };
    }

    public static MagicSpell FloatingForce(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "floating_force", (ParticleOptions)JerotesVillageParticleTypes.FLOATING_FORCE_DISPLAY.get(), JerotesVillageSounds.MAGIC_FLOATING_FORCE){

            public boolean spellFindUse() {
                return OtherSpellFind.FloatingForce(this.getCaster(), this.getSpellLevel(), this.getSpellLevel() * 8, this.getSpellLevel() * 5);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return this.getSpellLevel() * 8;
            }
        };
    }

    public static MagicSpell GravityForce(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "gravity_force", (ParticleOptions)JerotesVillageParticleTypes.GRAVITY_FORCE_DISPLAY.get(), JerotesVillageSounds.MAGIC_GRAVITY_FORCE){

            public boolean spellFindUse() {
                return OtherSpellFind.GravityForce(this.getCaster(), this.getSpellLevel(), this.getSpellLevel() * 8, this.getSpellLevel() * 5);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return this.getSpellLevel() * 8;
            }
        };
    }

    public static MagicSpell CorrosiveSnowCloud(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "corrosive_snow_cloud", (ParticleOptions)JerotesVillageParticleTypes.CORROSIVE_SNOW_CLOUD_DISPLAY.get(), JerotesVillageSounds.MAGIC_CORROSIVE_SNOW_CLOUD){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.CorrosiveSnowCloud(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel() * 6, this.getSpellLevel() * 6, this.getSpellLevel(), 1, Main.mobHeight((Entity)this.getTarget()) + 2.0f);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public float getSpellDistance() {
                return 32.0f;
            }

            public boolean canUseTargetNone() {
                return true;
            }
        };
    }

    public static MagicSpell UncleanBloodRain(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "unclean_blood_rain", (ParticleOptions)JerotesVillageParticleTypes.UNCLEAN_BLOOD_RAIN_DISPLAY.get(), JerotesVillageSounds.MAGIC_UNCLEAN_BLOOD_RAIN){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.UncleanBloodRain(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel() * 6, this.getSpellLevel() * 6, this.getSpellLevel(), 1, Main.mobHeight((Entity)this.getTarget()) + 2.0f);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public float getSpellDistance() {
                return 32.0f;
            }

            public boolean canUseTargetNone() {
                return true;
            }
        };
    }

    public static MagicSpell UncleanBloodFog(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "unclean_blood_fog", (ParticleOptions)JerotesVillageParticleTypes.UNCLEAN_BLOOD_FOG_DISPLAY.get(), JerotesVillageSounds.MAGIC_UNCLEAN_BLOOD_FOG){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.UncleanBloodFog(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel() * 6, this.getSpellLevel() * 6, this.getSpellLevel(), this.getSpellLevel() * 6, this.getSpellLevel(), 5 + this.getSpellLevel());
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public float getSpellDistance() {
                return 32.0f;
            }

            public boolean canUseTargetNone() {
                return true;
            }
        };
    }

    public static MagicSpell WarlockWhisper(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SHOOT, MagicType.MAIN, "warlock_whisper", (ParticleOptions)JerotesVillageParticleTypes.WARLOCK_WHISPER_DISPLAY.get(), JerotesVillageSounds.MAGIC_WARLOCK_WHISPER){

            public boolean spellFindUse() {
                return OtherSpellFind.WarlockWhisper(this.getCaster(), this.getSpellLevel() + 1, this.getSpellLevel() * 15, this.getSpellLevel() - 1, this.getSpellLevel() * 15, 1, 16 + this.getSpellLevel() * 2, 12 + this.getSpellLevel() * 2, 1.0 + (double)((float)this.getSpellLevel() * 0.1f), 32);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return 32.0f;
            }
        };
    }

    public static MagicSpell YetiDeter(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "yeti_deter", (ParticleOptions)JerotesVillageParticleTypes.YETI_DETER_DISPLAY.get(), JerotesVillageSounds.MAGIC_YETI_DETER){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.YetiDeter(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel(), this.getSpellLevel(), 1, this.getSpellLevel() * 6);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return this.getSpellLevel() * 6;
            }

            public boolean canUseTargetNone() {
                return true;
            }
        };
    }

    public static MagicSpell SerpenperthMeteor(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "serpenperth_meteor", (ParticleOptions)JerotesVillageParticleTypes.SERPENPERTH_METEOR_DISPLAY.get(), JerotesVillageSounds.MAGIC_SERPENPERTH_METEOR){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.SerpenperthMeteor(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel(), 1.0f + (float)this.getSpellLevel() * 0.5f, this.getSpellLevel() * 2, this.getSpellLevel() * 4, 4, Main.mobHeight((Entity)this.getTarget()) + 15.0f);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 5;
            }

            public float getSpellDistance() {
                return 32.0f;
            }
        };
    }

    public static MagicSpell OminousGear(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "ominous_gear", (ParticleOptions)JerotesVillageParticleTypes.OMINOUS_GEAR_DISPLAY.get(), JerotesVillageSounds.MAGIC_OMINOUS_GEAR){

            public boolean spellFindUse() {
                return OtherSpellFind.OminousGear(this.getCaster(), this.getSpellLevel() * 2, this.getSpellLevel() * 4, 12);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return 12.0f;
            }
        };
    }

    public static MagicSpell EvilSummoning(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "evil_summoning", (ParticleOptions)JerotesVillageParticleTypes.EVIL_SUMMONING_DISPLAY.get(), JerotesVillageSounds.MAGIC_EVIL_SUMMONING){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.EvilSummoning(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel() * 2, this.getSpellLevel() * 4, 4);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return 32.0f;
            }

            public boolean canUseTargetNone() {
                return true;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(UncleanTentacleEntity.class, this.getCaster().m_20191_().m_82377_(32.0, 32.0, 32.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() <= this.getSpellLevel() * 2;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell CogonSword(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "cogon_sword", (ParticleOptions)JerotesVillageParticleTypes.COGON_SWORD_DISPLAY.get(), JerotesVillageSounds.MAGIC_COGON_SWORD){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.CogonSword(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel() * 2, this.getSpellLevel() * 3, 16);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }

            public float getSpellDistance() {
                return 32.0f;
            }

            public boolean canUseTargetNone() {
                return true;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(CogonSwordEntity.class, this.getCaster().m_20191_().m_82377_(32.0, 32.0, 32.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() <= this.getSpellLevel() * 4;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell ImprisonVine(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "imprison_vine", (ParticleOptions)JerotesVillageParticleTypes.IMPRISON_VINE_DISPLAY.get(), JerotesVillageSounds.MAGIC_IMPRISON_VINE){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.ImprisonVine(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel() * 2, this.getSpellLevel() * 3);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }

            public float getSpellDistance() {
                return 32.0f;
            }

            public boolean canUseTargetNone() {
                return true;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(CogonSwordEntity.class, this.getCaster().m_20191_().m_82377_(32.0, 32.0, 32.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() <= this.getSpellLevel() * 4;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell ThornSpike(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "thorn_spike", (ParticleOptions)JerotesVillageParticleTypes.THORN_SPIKE_DISPLAY.get(), JerotesVillageSounds.MAGIC_THORN_SPIKE){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.ThornSpike(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel() * 4, 2.0f);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }

            public float getSpellDistance() {
                return 32.0f;
            }

            public boolean canUseTargetNone() {
                return true;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(ThornSpikeEntity.class, this.getCaster().m_20191_().m_82377_(32.0, 32.0, 32.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() <= this.getSpellLevel() * 4;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell BitterColdAltar(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "bitter_cold_altar", (ParticleOptions)JerotesVillageParticleTypes.BITTER_COLD_ALTAR_DISPLAY.get(), JerotesVillageSounds.MAGIC_BITTER_COLD_ALTAR){

            public boolean spellFindUse() {
                return OtherSpellFind.BitterColdAltar(this.getCaster(), 1, 1, 16);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public float getSpellDistance() {
                return 16.0f;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(BitterColdAltarEntity.class, this.getCaster().m_20191_().m_82377_(24.0, 24.0, 24.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.isEmpty();
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell ConjureCoilvineBotanize(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "conjure_coilvine_botanize", (ParticleOptions)JerotesVillageParticleTypes.CONJURE_COILVINE_BOTANIZE_DISPLAY.get(), JerotesVillageSounds.MAGIC_CONJURE_COILVINE_BOTANIZE){

            public boolean spellFindUse() {
                return OtherSpellFind.ConjureCoilvineBotanize(this.getCaster(), this.getSpellLevel() / 2, this.getSpellLevel(), 16);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return 16.0f;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(CoilvineBotanizeEntity.class, this.getCaster().m_20191_().m_82377_(32.0, 32.0, 32.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() <= this.getSpellLevel() * 4;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell VinePodBomb(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "vine_pod_bomb", (ParticleOptions)JerotesVillageParticleTypes.VINE_POD_BOMB_DISPLAY.get(), JerotesVillageSounds.MAGIC_VINE_POD_BOMB){

            public boolean spellFindUse() {
                return OtherSpellFind.VinePodBomb(this.getCaster(), (int)((float)this.getSpellLevel() / 1.5f), (int)((float)this.getSpellLevel() * 1.5f), 16);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return 16.0f;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(VinePodBombEntity.class, this.getCaster().m_20191_().m_82377_(32.0, 32.0, 32.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() <= this.getSpellLevel() * 4;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell ConjureBulge(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "conjure_bulge", (ParticleOptions)JerotesVillageParticleTypes.CONJURE_BULGE_DISPLAY.get(), JerotesVillageSounds.MAGIC_CONJURE_BULGE){

            public boolean spellFindUse() {
                return OtherSpellFind.ConjureBulge(this.getCaster(), this.getSpellLevel() / 2, this.getSpellLevel(), 16);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 1;
            }

            public float getSpellDistance() {
                return 16.0f;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(CoilvineBotanizeEntity.class, this.getCaster().m_20191_().m_82377_(32.0, 32.0, 32.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() <= this.getSpellLevel() * 4;
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell ConjureSeawave(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "conjure_seawave", (ParticleOptions)JerotesVillageParticleTypes.CONJURE_SEAWAVE_DISPLAY.get(), JerotesVillageSounds.MAGIC_CONJURE_SEAWAVE){

            public boolean spellFindUse() {
                return OtherSpellFind.ConjureSeawave(this.getCaster(), 1, 1, 16);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 4;
            }

            public float getSpellDistance() {
                return 16.0f;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(SeawaveEntity.class, this.getCaster().m_20191_().m_82377_(24.0, 24.0, 24.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() < this.getSpellLevel();
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell MalignasaurBomb(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "malignasaur_bomb", (ParticleOptions)JerotesVillageParticleTypes.MALIGNASAUR_BOMB_DISPLAY.get(), JerotesVillageSounds.MAGIC_MALIGNASAUR_BOMB){

            public boolean spellFindUse() {
                return OtherSpellFind.MalignasaurBomb(this.getCaster(), 48, 64, 12, this.getSpellLevel(), 2.0f + (float)this.getSpellLevel() * 0.25f);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 4;
            }

            public float getSpellDistance() {
                return 12.0f;
            }
        };
    }

    public static MagicSpell Discharge(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "discharge", (ParticleOptions)JerotesVillageParticleTypes.DISCHARGE_DISPLAY.get(), JerotesVillageSounds.MAGIC_DISCHARGE){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.Discharge(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel() * 6, 12, this.getSpellLevel() * 3);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 2;
            }

            public float getSpellDistance() {
                return 12.0f;
            }

            public boolean canUseTargetNone() {
                return true;
            }
        };
    }

    public static MagicSpell ConjureFlyingFireball(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "conjure_flying_fireball", (ParticleOptions)JerotesVillageParticleTypes.CONJURE_FLYING_FIREBALL_DISPLAY.get(), JerotesVillageSounds.MAGIC_CONJURE_FLYING_FIREBALL){

            public boolean spellFindUse() {
                return OtherSpellFind.ConjureFlyingFireball(this.getCaster(), 1, 1, 16);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public float getSpellDistance() {
                return 16.0f;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(FlyingFireballEntity.class, this.getCaster().m_20191_().m_82377_(24.0, 24.0, 24.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() < this.getSpellLevel();
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell ConjureIronTeeth(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "conjure_iron_teeth", (ParticleOptions)JerotesVillageParticleTypes.CONJURE_IRON_TEETH_DISPLAY.get(), JerotesVillageSounds.MAGIC_CONJURE_IRON_TEETH){

            public boolean spellFindUse() {
                return OtherSpellFind.ConjureIronTeeth(this.getCaster(), 1, 1, 16);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public float getSpellDistance() {
                return 16.0f;
            }

            public boolean canUse() {
                if (this.getCaster() != null) {
                    List list = this.getCaster().m_9236_().m_45976_(IronTeethEntity.class, this.getCaster().m_20191_().m_82377_(24.0, 24.0, 24.0));
                    list.removeIf(summon -> summon.m_269323_() != this.getCaster());
                    return super.canUse() && list.size() < this.getSpellLevel();
                }
                return super.canUse();
            }
        };
    }

    public static MagicSpell DazzlingLightFog(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "dazzling_light_fog", (ParticleOptions)JerotesVillageParticleTypes.DAZZLING_LIGHT_FOG_DISPLAY.get(), JerotesVillageSounds.MAGIC_DAZZLING_LIGHT_FOG){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.DazzlingLightFog(this.getCaster(), (entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster(), this.getSpellLevel() * 6, this.getSpellLevel() * 2, this.getSpellLevel(), this.getSpellLevel() * 2, this.getSpellLevel(), 5 + this.getSpellLevel());
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public float getSpellDistance() {
                return 32.0f;
            }

            public boolean canUseTargetNone() {
                return true;
            }

            public int baseSpellLevel() {
                return 3;
            }
        };
    }

    public static MagicSpell UndeadBanishing(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "undead_banishing", (ParticleOptions)JerotesVillageParticleTypes.UNDEAD_BANISHING_DISPLAY.get(), JerotesVillageSounds.MAGIC_UNDEAD_BANISHING){

            public boolean spellFindUse() {
                return OtherSpellFind.UndeadBanishing(this.getCaster(), this.getSpellLevel(), this.getSpellLevel(), this.getSpellLevel(), 24);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }

            public float getSpellDistance() {
                return 24.0f;
            }
        };
    }

    public static MagicSpell SpringRejuvenation(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.SELF, MagicType.MAIN, "spring_rejuvenation", (ParticleOptions)JerotesVillageParticleTypes.SPRING_REJUVENATION_DISPLAY.get(), JerotesVillageSounds.MAGIC_SPRING_REJUVENATION){

            public boolean spellFindUse() {
                return OtherSpellFind.SpringRejuvenation(this.getCaster(), this.getSpellLevel(), 12);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public int baseSpellLevel() {
                return 3;
            }

            public float getSpellDistance() {
                return 12.0f;
            }
        };
    }

    public static MagicSpell WiltMissile(int n, LivingEntity caster, Entity target) {
        return new MagicSpell(n, caster, target, MagicType.TARGET, MagicType.MAIN, "wilt_missile", (ParticleOptions)JerotesVillageParticleTypes.WILT_MISSILE_DISPLAY.get(), JerotesVillageSounds.MAGIC_WILT_MISSILE){

            public boolean spellFindUse() {
                LivingEntity livingEntity;
                Entity entity;
                return OtherSpellFind.WiltMissile(this.getCaster(), (Entity)((entity = this.getTarget()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : this.getCaster()), this.getSpellLevel(), this.getSpellLevel() * 6, 1, this.getSpellAccuracy(), 1, 1.0f, 3 + this.getSpellLevel(), this.getCaster() instanceof Player);
            }

            public String getSpellModId() {
                return "jerotesvillage";
            }

            public boolean canUseTargetNone() {
                return true;
            }

            public int baseSpellLevel() {
                return 4;
            }
        };
    }
}

