/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.util;

import com.jerotes.jerotesvillage.JerotesVillage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class IngredientGet {
    private static final Random RANDOM = new Random();

    public static ItemStack getRandomItemFromIngredients(NonNullList<Ingredient> ingredients) {
        List<Ingredient> nonEmptyIngredients = ingredients.stream().filter(ingredient -> !ingredient.m_43947_()).toList();
        if (nonEmptyIngredients.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Ingredient selectedIngredient = nonEmptyIngredients.get(RANDOM.nextInt(nonEmptyIngredients.size()));
        ItemStack[] possibleStacks = selectedIngredient.m_43908_();
        if (possibleStacks.length == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = possibleStacks[RANDOM.nextInt(possibleStacks.length)].m_41777_();
        stack.m_41764_(1);
        return stack;
    }

    public static List<ItemStack> getAllPossibleStacks(NonNullList<Ingredient> ingredients) {
        ArrayList<ItemStack> allStacks = new ArrayList<ItemStack>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.m_43947_()) continue;
            ItemStack[] stacks = ingredient.m_43908_();
            if (stacks.length > 0) {
                allStacks.addAll(Arrays.asList(stacks));
                continue;
            }
            try {
                Ingredient.Value[] values;
                Field valuesField = Ingredient.class.getDeclaredField("values");
                valuesField.setAccessible(true);
                for (Ingredient.Value value : values = (Ingredient.Value[])valuesField.get(ingredient)) {
                    if (!(value instanceof Ingredient.TagValue)) continue;
                    Field tagField = Ingredient.TagValue.class.getDeclaredField("tag");
                    tagField.setAccessible(true);
                    TagKey tag = (TagKey)tagField.get(value);
                    BuiltInRegistries.f_257033_.m_203431_(tag).ifPresent(holders -> holders.forEach(holder -> allStacks.add(new ItemStack((ItemLike)holder.m_203334_()))));
                }
            }
            catch (Exception e) {
                JerotesVillage.LOGGER.warn("Failed to get tag values from Ingredient", (Throwable)e);
            }
        }
        return allStacks;
    }

    public static Item getRandomItem(NonNullList<Ingredient> ingredients) {
        List<ItemStack> allStacks = IngredientGet.getAllPossibleStacks(ingredients);
        if (allStacks.isEmpty()) {
            return null;
        }
        ItemStack stack = allStacks.get(RANDOM.nextInt(allStacks.size()));
        return stack.m_41720_();
    }
}

