/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.util;

import javax.annotation.Nullable;
import net.minecraft.util.StringUtil;

public class PlayerName {
    private String skinName;
    @Nullable
    private String displayName;

    public PlayerName(String combined) {
        String[] parts = combined.split(":", 2);
        this.skinName = parts[0];
        if (parts.length > 1) {
            this.displayName = parts[1];
        }
    }

    public PlayerName(String skin, @Nullable String display) {
        this.skinName = skin;
        if (!StringUtil.m_14408_((String)display)) {
            this.displayName = display;
        }
    }

    public String getCombinedNames() {
        if (StringUtil.m_14408_((String)this.displayName) || this.skinName.equals(this.displayName)) {
            return this.skinName;
        }
        return this.skinName + ":" + this.displayName;
    }

    public void setNames(String name) {
        this.skinName = this.displayName = name;
    }

    public void setSkinName(String name) {
        this.skinName = name;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setDisplayName(String display) {
        this.displayName = display;
    }

    public boolean noDisplayName() {
        return this.displayName == null;
    }

    public boolean isInvalid() {
        return StringUtil.m_14408_((String)this.skinName);
    }

    public String getDisplayName() {
        if (!StringUtil.m_14408_((String)this.displayName)) {
            return this.displayName;
        }
        return this.skinName;
    }

    public boolean equals(Object o) {
        if (o instanceof PlayerName) {
            PlayerName other = (PlayerName)o;
            return this.getCombinedNames().equals(other.getCombinedNames());
        }
        return false;
    }

    public String toString() {
        return this.getCombinedNames();
    }
}

