/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.util;

import com.google.common.hash.Hashing;
import com.jerotes.jerotesvillage.entity.Other.ViewerEntity;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class PlayerSkin {
    private static final Map<UUID, SkinType> SKIN_TYPE_CACHE = new Object2ObjectOpenHashMap();
    private static final Map<String, ResourceLocation> SKIN_RESOURCE_CACHE = new Object2ObjectOpenHashMap();
    private static final Map<String, ResourceLocation> CAPE_RESOURCE_CACHE = new Object2ObjectOpenHashMap();
    private static final Map<String, ResourceLocation> ELYTRA_RESOURCE_CACHE = new Object2ObjectOpenHashMap();
    public static final ResourceLocation HIDE_FEATURE = new ResourceLocation("jerotesvillage", "hide_feature");

    public static SkinType getPlayerSkinType(@Nullable GameProfile profile) {
        SkinType type = SkinType.DEFAULT;
        if (profile != null && profile.isComplete()) {
            if (SKIN_TYPE_CACHE.containsKey(profile.getId())) {
                type = SKIN_TYPE_CACHE.get(profile.getId());
            } else {
                Minecraft mc = Minecraft.m_91087_();
                Map map = mc.m_91109_().m_118815_(profile);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    String stringType = ((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model");
                    type = PlayerSkin.getType(stringType);
                    SKIN_TYPE_CACHE.put(profile.getId(), type);
                } else {
                    type = PlayerSkin.getType(DefaultPlayerSkin.m_118629_((UUID)profile.getId()));
                }
            }
        }
        return type;
    }

    private static SkinType getType(@Nullable String stringType) {
        return "slim".equals(stringType) ? SkinType.SLIM : SkinType.DEFAULT;
    }

    public static ResourceLocation getPlayerSkin(ViewerEntity entity) {
        String lowerName = entity.getUsername().getSkinName().toLowerCase(Locale.ROOT);
        ResourceLocation location = SKIN_RESOURCE_CACHE.get(lowerName);
        if (location != null) {
            return location;
        }
        return PlayerSkin.getTexture(entity).orElse(DefaultPlayerSkin.m_118626_());
    }

    private static Optional<ResourceLocation> getTexture(ViewerEntity entity) {
        Minecraft mc;
        Map map;
        if (entity.isTextureAvailable(MinecraftProfileTexture.Type.SKIN)) {
            return Optional.of(entity.getTexture(MinecraftProfileTexture.Type.SKIN));
        }
        GameProfile profile = entity.getProfile();
        if (profile != null && !profile.isComplete()) {
            return PlayerSkin.getDefault(profile);
        }
        if (profile != null && profile.getName() != null && (map = (mc = Minecraft.m_91087_()).m_91109_().m_118815_(profile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)profileTexture.getHash()).toString();
            ResourceLocation location = SkinManager.m_242632_((MinecraftProfileTexture.Type)MinecraftProfileTexture.Type.SKIN, (String)s);
            if (mc.f_90987_.m_174786_(location, (AbstractTexture)MissingTextureAtlasSprite.m_118080_()) != MissingTextureAtlasSprite.m_118080_()) {
                return Optional.of(location);
            }
            RenderSystem.recordRenderCall(() -> mc.m_91109_().m_118828_(profileTexture, MinecraftProfileTexture.Type.SKIN, entity.getSkinCallback()));
        }
        return PlayerSkin.getDefault(profile);
    }

    private static Optional<ResourceLocation> getDefault(@Nullable GameProfile profile) {
        return Optional.of(profile != null && profile.isComplete() ? DefaultPlayerSkin.m_118627_((UUID)profile.getId()) : DefaultPlayerSkin.m_118626_());
    }

    public static void onResourceManagerReload(ResourceManager resourceManager) {
        SKIN_RESOURCE_CACHE.clear();
        Map skins = resourceManager.m_214159_("skins", resourceLocation -> resourceLocation.m_135827_().equals("jerotesvillage") && resourceLocation.m_135815_().endsWith(".png"));
        Pattern skinPattern = Pattern.compile("skins/([a-z0-9_.-]*).png");
        for (ResourceLocation location : skins.keySet()) {
            Matcher matcher = skinPattern.matcher(location.m_135815_());
            if (!matcher.find()) continue;
            String name = matcher.group(1);
            SKIN_RESOURCE_CACHE.put(name, location);
        }
        PlayerSkin.parseHideableTexture(resourceManager, "capes", CAPE_RESOURCE_CACHE);
        PlayerSkin.parseHideableTexture(resourceManager, "elytra", ELYTRA_RESOURCE_CACHE);
    }

    private static void parseHideableTexture(ResourceManager resourceManager, String type, Map<String, ResourceLocation> cache) {
        cache.clear();
        Pattern pattern = Pattern.compile(type + "/([a-z0-9_.-]*).(png|txt)");
        Map resources = resourceManager.m_214159_(type, resourceLocation -> resourceLocation.m_135827_().equals("jerotesvillage") && (resourceLocation.m_135815_().endsWith(".png") || resourceLocation.m_135815_().endsWith(".txt")));
        for (ResourceLocation location : resources.keySet()) {
            Matcher matcher = pattern.matcher(location.m_135815_());
            if (!matcher.find()) continue;
            String name = matcher.group(1);
            boolean ignore = Objects.equals(matcher.group(2), "txt");
            cache.put(name, ignore ? HIDE_FEATURE : location);
        }
    }

    public static ResourceManagerReloadListener resourceManagerReloadListener() {
        return PlayerSkin::onResourceManagerReload;
    }

    public static enum SkinType {
        DEFAULT,
        SLIM;

    }
}

