/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.util;

import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.network.JerotesVillageLevelData;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnRules {
    public static boolean checkSurfaceWaterSpawnRules(EntityType<? extends Mob> mob, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        int i = levelAccessor.m_5736_();
        int j = i - 13;
        return blockPos.m_123342_() >= j && blockPos.m_123342_() <= i && levelAccessor.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && levelAccessor.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public static boolean NeutralSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean BatSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && SpawnRules.checkBatSpawnRules(entityType, levelAccessor, mobSpawnType, blockPos, randomSource);
    }

    public static boolean checkBatSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (blockPos.m_123342_() >= levelAccessor.m_5736_()) {
            return false;
        }
        int n = levelAccessor.m_46803_(blockPos);
        int n2 = 4;
        if (SpawnRules.isHalloween()) {
            n2 = 7;
        } else if (randomSource.m_188499_()) {
            return false;
        }
        if (n > randomSource.m_188503_(n2)) {
            return false;
        }
        return Bat.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean isHalloween() {
        LocalDate $$0 = LocalDate.now();
        int $$1 = $$0.get(ChronoField.DAY_OF_MONTH);
        int $$2 = $$0.get(ChronoField.MONTH_OF_YEAR);
        return $$2 == 10 && $$1 >= 20 || $$2 == 11 && $$1 <= 3;
    }

    public static boolean CarvedSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean AnimalSpawn(int num, double area, EntityType<? extends Animal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Animal.m_218104_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean ArchnosedHornbeastSpawn(int num, double area, EntityType<? extends Animal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        boolean bl = false;
        List playerList = levelAccessor.m_6907_();
        playerList.removeIf(player -> player.m_9236_() != levelAccessor);
        for (Player player2 : playerList) {
            if (!(player2.getPersistentData().m_128459_("jerotesvillage_bright_land_heart") > 0.0) && !player2.m_21023_((MobEffect)JerotesVillageMobEffects.BRIGHT_LAND_HEART.get())) continue;
            bl = true;
            break;
        }
        return bl && list.size() < num && Animal.m_218104_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean WaterFishSpawn(int num, double area, EntityType<? extends WaterAnimal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && WaterAnimal.m_218282_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean WaterAnimalSpawn(int num, double area, EntityType<? extends WaterAnimal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && WaterAnimal.m_218282_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean WaterMobSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && SpawnRules.checkSurfaceWaterSpawnRules(entityType, levelAccessor, mobSpawnType, blockPos, randomSource);
    }

    public static boolean DarkMonsterSpawn(int num, double area, EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = serverLevelAccessor.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Monster.m_219013_(entityType, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean DarisorderSpawn(int num, double area, EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = serverLevelAccessor.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Monster.m_219013_(entityType, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean GlowSquidSpawn(int num, double area, EntityType<? extends Mob> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = serverLevelAccessor.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && blockPos.m_123342_() <= serverLevelAccessor.m_5736_() - 33 && serverLevelAccessor.m_45524_(blockPos, 0) == 0 && serverLevelAccessor.m_8055_(blockPos).m_60713_(Blocks.f_49990_);
    }

    public static boolean WickedRidculeCallsSpawn(int num, double area, EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (JerotesVillageLevelData.get((LevelAccessor)serverLevelAccessor) != null && !JerotesVillageLevelData.get((LevelAccessor)serverLevelAccessor).WickedRidiculeNight) {
            List list = serverLevelAccessor.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
            list.removeIf(entity -> entity.m_6095_() != entityType);
            return list.size() < num && Monster.m_219013_(entityType, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
        }
        return Monster.m_219013_(entityType, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean LightMonsterSpawn(int num, double area, EntityType<? extends Monster> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Monster.m_219019_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean NPCSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean SerponSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        double areas = OtherMainConfig.BossSpawnRestrictionRange;
        List listBoss = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)areas, (double)areas, (double)areas));
        listBoss.removeIf(entity -> entity.m_6095_() != JerotesVillageEntityType.SERPON_COMBAT_EXECUTER.get());
        return list.size() < num && JerotesVillageLevelData.get(levelAccessor) != null && !JerotesVillageLevelData.get((LevelAccessor)levelAccessor).SerponAway && listBoss.isEmpty() && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean WaterNPCSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> entity.m_6095_() != entityType);
        return list.size() < num && SpawnRules.checkSurfaceWaterSpawnRules(entityType, levelAccessor, mobSpawnType, blockPos, randomSource);
    }

    public static boolean EliteSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (area != OtherMainConfig.EliteSpawnRestrictionRange) {
            area = OtherMainConfig.EliteSpawnRestrictionRange;
        }
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        if (!(OtherMainConfig.EliteOnlyOne || OtherMainConfig.EliteAndBossOnlyOne || OtherMainConfig.SameTypeEliteOnlyOne)) {
            num *= 8;
        }
        list.removeIf(entity -> entity.m_6095_() != entityType && (!OtherMainConfig.EliteOnlyOne || !(entity instanceof EliteEntity) || SpawnRules.isSameMod(entityType, entity.m_6095_())) && (!OtherMainConfig.EliteAndBossOnlyOne || !(entity instanceof BossEntity) && !(entity instanceof EliteEntity) || SpawnRules.isSameMod(entityType, entity.m_6095_())));
        return list.size() < num && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean BossSpawn(int num, double area, EntityType<? extends Mob> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (area != OtherMainConfig.BossSpawnRestrictionRange) {
            area = OtherMainConfig.BossSpawnRestrictionRange;
        }
        List list = levelAccessor.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        if (!(OtherMainConfig.BossOnlyOne || OtherMainConfig.EliteAndBossOnlyOne || OtherMainConfig.SameTypeBossOnlyOne)) {
            num *= 4;
        }
        list.removeIf(entity -> entity.m_6095_() != entityType && (!OtherMainConfig.BossOnlyOne || !(entity instanceof BossEntity) || SpawnRules.isSameMod(entityType, entity.m_6095_())) && (!OtherMainConfig.EliteAndBossOnlyOne || !(entity instanceof BossEntity) && !(entity instanceof EliteEntity) || SpawnRules.isSameMod(entityType, entity.m_6095_())));
        return list.size() < num && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static boolean BossSpawnFind(EntityType<? extends BossEntity> entityType, Entity posEntity) {
        double area = OtherMainConfig.BossSpawnRestrictionRange;
        List list = posEntity.m_9236_().m_45976_(Mob.class, posEntity.m_20191_().m_82377_(area, area, area));
        list.removeIf(entity -> !(OtherMainConfig.SameTypeBossOnlyOne && entity.m_6095_() == entityType || OtherMainConfig.BossOnlyOne && entity instanceof BossEntity && !SpawnRules.isSameMod(entityType, entity.m_6095_()) || OtherMainConfig.EliteAndBossOnlyOne && (entity instanceof BossEntity || entity instanceof EliteEntity) && !SpawnRules.isSameMod(entityType, entity.m_6095_())));
        if (!list.isEmpty() && posEntity.m_9236_() instanceof ServerLevel) {
            posEntity.m_213846_((Component)Component.m_237115_((String)"boss.jerotesvillage.can_not_spawn").m_130940_(ChatFormatting.BLUE));
        }
        return list.isEmpty();
    }

    public static boolean BossSpawnFind(EntityType<? extends BossEntity> entityType, Level level, BlockPos blockPos) {
        double area = OtherMainConfig.BossSpawnRestrictionRange;
        List list = level.m_45976_(Mob.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)area, (double)area, (double)area));
        list.removeIf(entity -> !(OtherMainConfig.SameTypeBossOnlyOne && entity.m_6095_() == entityType || OtherMainConfig.BossOnlyOne && entity instanceof BossEntity && !SpawnRules.isSameMod(entityType, entity.m_6095_()) || OtherMainConfig.EliteAndBossOnlyOne && (entity instanceof BossEntity || entity instanceof EliteEntity) && !SpawnRules.isSameMod(entityType, entity.m_6095_())));
        return list.isEmpty();
    }

    public static boolean isSameMod(EntityType<?> entityType, EntityType<?> entityType2) {
        return Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entityType)).m_135827_().equals(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(entityType2)).m_135827_());
    }
}

