/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ViewerNameManager
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ViewerNameManager INSTANCE = new ViewerNameManager();
    private static final Gson GSON = new Gson();
    private List<String> nameList = new ArrayList<String>();
    private final Random random = new Random();

    public static ViewerNameManager getInstance() {
        return INSTANCE;
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.nameList.clear();
        try {
            for (String namespace : resourceManager.m_7187_()) {
                ResourceLocation location = new ResourceLocation(namespace, "viewer_name/viewer_name.json");
                resourceManager.m_213713_(location).ifPresent(resource -> {
                    try (InputStream is = resource.m_215507_();
                         InputStreamReader reader = new InputStreamReader(is);){
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        JsonArray values = json.getAsJsonArray("values");
                        for (JsonElement element : values) {
                            String name = element.getAsString();
                            if (this.nameList.contains(name)) continue;
                            this.nameList.add(name);
                        }
                        LOGGER.debug("Loaded {} names from namespace: {}", (Object)values.size(), (Object)namespace);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load viewer names from {}", (Object)location, (Object)e);
                    }
                });
            }
            if (this.nameList.isEmpty()) {
                this.nameList.add("Jerotes_");
                LOGGER.warn("No viewer names loaded, using default");
            } else {
                LOGGER.info("Loaded {} viewer names", (Object)this.nameList.size());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load viewer names", (Throwable)e);
            this.nameList.add("Jerotes_");
        }
    }

    public String getRandomName() {
        if (this.nameList.isEmpty()) {
            return "Jerotes_";
        }
        return this.nameList.get(this.random.nextInt(this.nameList.size()));
    }

    public List<String> getAllNames() {
        return new ArrayList<String>(this.nameList);
    }

    public boolean containsName(String name) {
        return this.nameList.contains(name);
    }
}

