/*
 * Decompiled with CFR 0.152.
 */
package net.night.throwable_spear.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.night.throwable_spear.client.model.CopperSpearModel;
import net.night.throwable_spear.client.model.DiamondSpearModel;
import net.night.throwable_spear.client.model.GoldenSpearModel;
import net.night.throwable_spear.client.model.IronSpearModel;
import net.night.throwable_spear.client.model.NetheriteSpearModel;
import net.night.throwable_spear.client.model.StoneSpearModel;
import net.night.throwable_spear.client.model.WoodenSpearModel;
import net.night.throwable_spear.client.renderer.CopperSpearRenderer;
import net.night.throwable_spear.client.renderer.DiamondSpearRenderer;
import net.night.throwable_spear.client.renderer.GoldenSpearRenderer;
import net.night.throwable_spear.client.renderer.IronSpearRenderer;
import net.night.throwable_spear.client.renderer.NetheriteSpearRenderer;
import net.night.throwable_spear.client.renderer.StoneSpearRenderer;
import net.night.throwable_spear.client.renderer.WoodenSpearRenderer;
import net.night.throwable_spear.network.NetworkHandler;
import net.night.throwable_spear.registry.ModEntities;

public class Throwable_spearClient {
    public static final KeyMapping THROW_SPEAR_KEY = new KeyMapping("key.throwable_spear.throw_spear", InputConstants.Type.KEYSYM, 71, KeyMapping.Category.GAMEPLAY);
    private static boolean rightClickHeld = false;

    public static void init() {
        KeyMappingRegistry.register((KeyMapping)THROW_SPEAR_KEY);
        EntityModelLayerRegistry.register((ModelLayerLocation)WoodenSpearModel.LAYER_LOCATION, WoodenSpearModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)StoneSpearModel.LAYER_LOCATION, StoneSpearModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CopperSpearModel.LAYER_LOCATION, CopperSpearModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)IronSpearModel.LAYER_LOCATION, IronSpearModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)GoldenSpearModel.LAYER_LOCATION, GoldenSpearModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)DiamondSpearModel.LAYER_LOCATION, DiamondSpearModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)NetheriteSpearModel.LAYER_LOCATION, NetheriteSpearModel::createBodyLayer);
        EntityRendererRegistry.register(ModEntities.WOODEN_SPEAR_ENTITY, WoodenSpearRenderer::new);
        EntityRendererRegistry.register(ModEntities.STONE_SPEAR_ENTITY, StoneSpearRenderer::new);
        EntityRendererRegistry.register(ModEntities.COPPER_SPEAR_ENTITY, CopperSpearRenderer::new);
        EntityRendererRegistry.register(ModEntities.IRON_SPEAR_ENTITY, IronSpearRenderer::new);
        EntityRendererRegistry.register(ModEntities.GOLDEN_SPEAR_ENTITY, GoldenSpearRenderer::new);
        EntityRendererRegistry.register(ModEntities.DIAMOND_SPEAR_ENTITY, DiamondSpearRenderer::new);
        EntityRendererRegistry.register(ModEntities.NETHERITE_SPEAR_ENTITY, NetheriteSpearRenderer::new);
        ClientTickEvent.CLIENT_POST.register(Throwable_spearClient::onClientTick);
    }

    private static void onClientTick(Minecraft minecraft) {
        if (minecraft.player == null) {
            return;
        }
        rightClickHeld = minecraft.options.keyUse.isDown();
        while (THROW_SPEAR_KEY.consumeClick()) {
            if (!rightClickHeld || !Throwable_spearClient.isHoldingSpear(minecraft)) continue;
            NetworkHandler.sendThrowSpearPacket();
        }
    }

    private static boolean isHoldingSpear(Minecraft minecraft) {
        if (minecraft.player == null) {
            return false;
        }
        ItemStack mainHand = minecraft.player.getMainHandItem();
        return mainHand.is(Items.WOODEN_SPEAR) || mainHand.is(Items.STONE_SPEAR) || mainHand.is(Items.COPPER_SPEAR) || mainHand.is(Items.IRON_SPEAR) || mainHand.is(Items.GOLDEN_SPEAR) || mainHand.is(Items.DIAMOND_SPEAR) || mainHand.is(Items.NETHERITE_SPEAR);
    }

    public static void onMouseScroll(double delta) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return;
        }
        if (rightClickHeld && delta > 0.0 && Throwable_spearClient.isHoldingSpear(minecraft)) {
            NetworkHandler.sendThrowSpearPacket();
        }
    }
}

