/*
 * Decompiled with CFR 0.152.
 */
package net.night.throwable_spear.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.night.throwable_spear.client.model.IronSpearModel;
import net.night.throwable_spear.client.renderer.state.SpearRenderState;
import net.night.throwable_spear.entity.IronSpearEntity;
import org.joml.Quaternionfc;

public class IronSpearRenderer
extends EntityRenderer<IronSpearEntity, SpearRenderState> {
    public static final Identifier TEXTURE = Identifier.fromNamespaceAndPath((String)"throwable_spear", (String)"textures/entity/iron_spear.png");
    private final IronSpearModel model;

    public IronSpearRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new IronSpearModel(context.bakeLayer(IronSpearModel.LAYER_LOCATION));
    }

    public SpearRenderState createRenderState() {
        return new SpearRenderState();
    }

    public void extractRenderState(IronSpearEntity entity, SpearRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        state.yRot = Mth.lerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot());
        state.xRot = Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
        state.hasEnchantmentGlint = entity.isFoil();
    }

    public void submit(SpearRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        super.submit((EntityRenderState)state, poseStack, collector, cameraState);
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(state.xRot + 90.0f));
        poseStack.translate(0.0, 1.5, 0.0);
        this.model.setupAnim(state);
        collector.submitModelPart(this.model.getSpear(), poseStack, RenderTypes.entitySolid((Identifier)TEXTURE), 0xF000F0, OverlayTexture.NO_OVERLAY, null);
        if (state.hasEnchantmentGlint) {
            collector.submitModelPart(this.model.getSpear(), poseStack, RenderTypes.entityGlint(), 0xF000F0, OverlayTexture.NO_OVERLAY, null);
        }
        poseStack.popPose();
    }
}

