/*
 * Decompiled with CFR 0.152.
 */
package net.night.throwable_spear.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ThrownTridentRenderState;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.arrow.ThrownTrident;
import net.night.throwable_spear.client.model.CopperSpearModel;
import net.night.throwable_spear.client.model.DiamondSpearModel;
import net.night.throwable_spear.client.model.GoldenSpearModel;
import net.night.throwable_spear.client.model.IronSpearModel;
import net.night.throwable_spear.client.model.NetheriteSpearModel;
import net.night.throwable_spear.client.model.StoneSpearModel;
import net.night.throwable_spear.client.model.WoodenSpearModel;
import org.joml.Quaternionfc;

public class SpearTridentRenderer
extends EntityRenderer<ThrownTrident, ThrownTridentRenderState> {
    private final WoodenSpearModel woodenModel;
    private final StoneSpearModel stoneModel;
    private final CopperSpearModel copperModel;
    private final IronSpearModel ironModel;
    private final GoldenSpearModel goldenModel;
    private final DiamondSpearModel diamondModel;
    private final NetheriteSpearModel netheriteModel;
    private static final Identifier WOODEN_TEXTURE = Identifier.fromNamespaceAndPath((String)"throwable_spear", (String)"textures/entity/wooden_spear.png");
    private static final Identifier STONE_TEXTURE = Identifier.fromNamespaceAndPath((String)"throwable_spear", (String)"textures/entity/stone_spear.png");
    private static final Identifier COPPER_TEXTURE = Identifier.fromNamespaceAndPath((String)"throwable_spear", (String)"textures/entity/copper_spear.png");
    private static final Identifier IRON_TEXTURE = Identifier.fromNamespaceAndPath((String)"throwable_spear", (String)"textures/entity/iron_spear.png");
    private static final Identifier GOLDEN_TEXTURE = Identifier.fromNamespaceAndPath((String)"throwable_spear", (String)"textures/entity/golden_spear.png");
    private static final Identifier DIAMOND_TEXTURE = Identifier.fromNamespaceAndPath((String)"throwable_spear", (String)"textures/entity/diamond_spear.png");
    private static final Identifier NETHERITE_TEXTURE = Identifier.fromNamespaceAndPath((String)"throwable_spear", (String)"textures/entity/netherite_spear.png");
    private static final Identifier TRIDENT_TEXTURE = Identifier.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/trident.png");

    public SpearTridentRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.woodenModel = new WoodenSpearModel(context.bakeLayer(WoodenSpearModel.LAYER_LOCATION));
        this.stoneModel = new StoneSpearModel(context.bakeLayer(StoneSpearModel.LAYER_LOCATION));
        this.copperModel = new CopperSpearModel(context.bakeLayer(CopperSpearModel.LAYER_LOCATION));
        this.ironModel = new IronSpearModel(context.bakeLayer(IronSpearModel.LAYER_LOCATION));
        this.goldenModel = new GoldenSpearModel(context.bakeLayer(GoldenSpearModel.LAYER_LOCATION));
        this.diamondModel = new DiamondSpearModel(context.bakeLayer(DiamondSpearModel.LAYER_LOCATION));
        this.netheriteModel = new NetheriteSpearModel(context.bakeLayer(NetheriteSpearModel.LAYER_LOCATION));
    }

    public ThrownTridentRenderState createRenderState() {
        return new ThrownTridentRenderState();
    }

    public void extractRenderState(ThrownTrident entity, ThrownTridentRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        state.yRot = Mth.lerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot());
        state.xRot = Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
    }

    public void submit(ThrownTridentRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        super.submit((EntityRenderState)state, poseStack, collector, cameraState);
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yRot - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(state.xRot + 90.0f));
        this.woodenModel.setupAnim(state);
        collector.submitModelPart(this.woodenModel.getSpear(), poseStack, RenderTypes.entitySolid((Identifier)WOODEN_TEXTURE), state.lightCoords, OverlayTexture.NO_OVERLAY, null);
        poseStack.popPose();
    }
}

