/*
 * Decompiled with CFR 0.152.
 */
package net.night.throwable_spear.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class SpearConfig {
    public float woodenSpearDamage = 4.0f;
    public float stoneSpearDamage = 5.0f;
    public float copperSpearDamage = 6.0f;
    public float ironSpearDamage = 7.0f;
    public float goldenSpearDamage = 8.0f;
    public float diamondSpearDamage = 9.0f;
    public float netheriteSpearDamage = 10.0f;
    private static SpearConfig instance;
    private static final String CONFIG_FILE = "config/throwable_spear.json";

    public static SpearConfig getInstance() {
        if (instance == null) {
            instance = SpearConfig.load();
        }
        return instance;
    }

    private static SpearConfig load() {
        SpearConfig spearConfig;
        File configFile = new File(CONFIG_FILE);
        if (!configFile.exists()) {
            System.out.println("[Throwable Spear] Config file not found, creating default config...");
            SpearConfig defaultConfig = new SpearConfig();
            defaultConfig.save();
            return defaultConfig;
        }
        FileReader reader = new FileReader(configFile);
        try {
            Gson gson = new Gson();
            SpearConfig config = (SpearConfig)gson.fromJson((Reader)reader, SpearConfig.class);
            System.out.println("[Throwable Spear] Loaded Spear config from file");
            spearConfig = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[Throwable Spear] Failed to load config, using defaults: " + e.getMessage());
                return new SpearConfig();
            }
        }
        reader.close();
        return spearConfig;
    }

    public void save() {
        File configFile = new File(CONFIG_FILE);
        File parentDir = configFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)this, (Appendable)writer);
            System.out.println("[Throwable Spear] Saved Spear config to file");
        }
        catch (IOException e) {
            System.err.println("[Throwable Spear] Failed to save config: " + e.getMessage());
        }
    }

    public static void reload() {
        instance = SpearConfig.load();
    }
}

