/*
 * Decompiled with CFR 0.152.
 */
package net.night.throwable_spear.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.night.throwable_spear.config.SpearConfig;
import net.night.throwable_spear.registry.ModEntities;

public class IronSpearEntity
extends Projectile {
    private static final EntityDataAccessor<Boolean> IN_GROUND = SynchedEntityData.defineId(IronSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(IronSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(IronSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private ItemStack spearItem = new ItemStack((ItemLike)Items.IRON_SPEAR);
    private boolean dealtDamage = false;
    private boolean noPhysics = false;
    public int clientSideReturnSpearTickCount = 0;
    private boolean rotationFrozen = false;

    public IronSpearEntity(EntityType<? extends IronSpearEntity> entityType, Level level) {
        super(entityType, level);
    }

    public IronSpearEntity(Level level, LivingEntity shooter, ItemStack spearItem) {
        super((EntityType)ModEntities.IRON_SPEAR_ENTITY.get(), level);
        this.setOwner((Entity)shooter);
        this.spearItem = spearItem.copy();
        this.entityData.set(ID_FOIL, (Object)spearItem.hasFoil());
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(spearItem));
        Vec3 eyePos = shooter.getEyePosition();
        Vec3 lookVector = shooter.getLookAngle();
        double offsetDistance = 0.5;
        this.setPos(eyePos.x + lookVector.x * offsetDistance, eyePos.y + 0.3, eyePos.z + lookVector.z * offsetDistance);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(IN_GROUND, (Object)false);
        builder.define(ID_FOIL, (Object)false);
        builder.define(ID_LOYALTY, (Object)0);
    }

    public void tick() {
        boolean inGround = (Boolean)this.entityData.get(IN_GROUND);
        if (inGround && !this.dealtDamage) {
            this.dealtDamage = true;
        }
        Entity owner = this.getOwner();
        byte loyalty = (Byte)this.entityData.get(ID_LOYALTY);
        if (loyalty > 0 && (this.dealtDamage || this.noPhysics) && owner != null) {
            if (!this.isAcceptibleReturnOwner()) {
                Level level;
                if (!this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.spawnAtLocation(serverLevel, this.spearItem.copy());
                    this.discard();
                }
            } else {
                this.noPhysics = true;
                if (!this.rotationFrozen) {
                    this.rotationFrozen = true;
                }
                Vec3 ownerEyePos = owner.getEyePosition();
                Vec3 currentSpearPos = this.position();
                Vec3 toOwner = ownerEyePos.subtract(currentSpearPos);
                double acceleration = 0.05 * (double)loyalty;
                Vec3 directionToOwner = toOwner.normalize();
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(directionToOwner.scale(acceleration)));
                if (this.level().isClientSide() && this.clientSideReturnSpearTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    if (this.distanceToSqr(owner) < 4.0 && player.getInventory().add(this.spearItem.copy())) {
                        this.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 1.0f);
                        this.discard();
                    }
                }
            }
            Vec3 newPos = this.position().add(this.getDeltaMovement());
            this.setPos(newPos);
            if (this.level().isClientSide()) {
                this.xOld = this.getX();
                this.yOld = this.getY();
                this.zOld = this.getZ();
            }
            super.tick();
            return;
        }
        super.tick();
        if (loyalty > 0 && (this.dealtDamage || this.noPhysics) && owner != null && this.isAcceptibleReturnOwner()) {
            return;
        }
        if (inGround) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setNoGravity(true);
            if (!this.level().isClientSide()) {
                this.checkPlayerPickup();
            }
            return;
        }
        Vec3 currentPos = this.position();
        Vec3 motion = this.getDeltaMovement();
        motion = motion.add(0.0, -0.03, 0.0);
        motion = motion.scale(0.99);
        Vec3 nextPos = currentPos.add(motion);
        AABB searchBox = this.getBoundingBox().expandTowards(motion).inflate(1.0);
        List entities = this.level().getEntities((Entity)this, searchBox, entity -> !entity.isSpectator() && entity.isPickable() && entity != this.getOwner());
        EntityHitResult entityHit = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity2 : entities) {
            double distance;
            AABB entityBox = entity2.getBoundingBox().inflate(0.3);
            Optional optional = entityBox.clip(currentPos, nextPos);
            if (!optional.isPresent() || !((distance = currentPos.distanceToSqr((Vec3)optional.get())) < closestDistance)) continue;
            closestDistance = distance;
            entityHit = new EntityHitResult(entity2, (Vec3)optional.get());
        }
        if (entityHit != null) {
            this.onHitEntity(entityHit);
            return;
        }
        if (!this.noPhysics) {
            Vec3 extendedNextPos = currentPos.add(motion.scale(1.5));
            BlockHitResult blockHit = this.level().clip(new ClipContext(currentPos, extendedNextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (blockHit.getType() != HitResult.Type.MISS) {
                Vec3 hitLoc = blockHit.getLocation();
                Direction dir = blockHit.getDirection();
                double penetrationDepth = dir == Direction.UP ? -0.1 : (dir == Direction.DOWN ? -0.15 : -0.2);
                Vec3 normal = new Vec3((double)dir.getStepX(), (double)dir.getStepY(), (double)dir.getStepZ());
                Vec3 finalPos = hitLoc.add(normal.scale(penetrationDepth));
                this.setPos(finalPos);
                this.setDeltaMovement(Vec3.ZERO);
                this.setNoGravity(true);
                this.entityData.set(IN_GROUND, (Object)true);
                this.playSound(SoundEvents.TRIDENT_HIT_GROUND, 1.0f, 1.0f);
                return;
            }
        }
        this.setPos(nextPos);
        this.setDeltaMovement(motion);
        this.updateRotation();
    }

    protected void updateRotation() {
        if (this.rotationFrozen) {
            return;
        }
        Vec3 motion = this.getDeltaMovement();
        double horizontalDist = motion.horizontalDistance();
        if (horizontalDist > 0.001) {
            float yaw = (float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.29577951308232);
            this.setYRot(yaw);
            float pitch = (float)(Mth.atan2((double)motion.y, (double)horizontalDist) * 57.29577951308232);
            this.setXRot(pitch);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.level().isClientSide()) {
            return;
        }
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            entity = this.level();
            if (entity instanceof ServerLevel) {
                float finalDamage;
                ServerLevel serverLevel = (ServerLevel)entity;
                float baseDamage = SpearConfig.getInstance().ironSpearDamage;
                DamageSource damageSource = this.damageSources().thrown((Entity)this, this.getOwner());
                boolean hitSuccess = target.hurtServer(serverLevel, damageSource, finalDamage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.spearItem, (Entity)target, (DamageSource)damageSource, (float)baseDamage));
                if (hitSuccess) {
                    this.dealtDamage = true;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)target, (DamageSource)damageSource, (ItemStack)this.spearItem);
                    Vec3 knockbackDirection = this.getDeltaMovement().normalize();
                    target.knockback(0.1, -knockbackDirection.x, -knockbackDirection.z);
                    if (this.spearItem.isDamageableItem()) {
                        this.spearItem.hurtAndBreak(1, serverLevel, this.getOwner() instanceof ServerPlayer ? (ServerPlayer)this.getOwner() : null, item -> {
                            this.discard();
                            this.playSound((SoundEvent)SoundEvents.ITEM_BREAK.value(), 1.0f, 1.0f);
                        });
                    }
                    this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
                    Vec3 impactMotion = this.getDeltaMovement();
                    float impactHorizontalDist = (float)impactMotion.horizontalDistance();
                    this.setDeltaMovement(impactMotion.multiply(0.02, 0.1, 0.02));
                    byte loyalty = (Byte)this.entityData.get(ID_LOYALTY);
                    if (loyalty > 0) {
                        this.rotationFrozen = true;
                    } else {
                        float finalYaw = (float)(Mth.atan2((double)impactMotion.x, (double)impactMotion.z) * 180.0 / Math.PI) + 180.0f;
                        float finalPitch = (float)(Mth.atan2((double)(-impactMotion.y), (double)impactHorizontalDist) * 180.0 / Math.PI) + 15.0f;
                        this.setYRot(finalYaw);
                        this.setXRot(finalPitch);
                        this.yRotO = finalYaw;
                        this.xRotO = finalPitch;
                        this.rotationFrozen = true;
                    }
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 4096.0;
    }

    protected ProjectileDeflection hitTargetOrDeflectSelf(HitResult result) {
        return ProjectileDeflection.NONE;
    }

    public ItemStack getWeaponItem() {
        return this.spearItem;
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    private byte getLoyaltyFromItem(ItemStack stack) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (byte)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverLevel, (ItemStack)stack, (Entity)this);
        }
        return 0;
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        if (entity == null || !entity.isAlive()) {
            return false;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return !serverPlayer.isSpectator();
        }
        return true;
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)0.5f, (float)0.5f);
    }

    private void checkPlayerPickup() {
        if (this.level().isClientSide()) {
            return;
        }
        AABB searchBox = this.getBoundingBox().inflate(2.5);
        List nearbyPlayers = this.level().getEntitiesOfClass(Player.class, searchBox);
        for (Player player : nearbyPlayers) {
            double distance = player.distanceToSqr((Entity)this);
            if (!(distance < 5.5) || !player.getInventory().add(this.spearItem.copy())) continue;
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.discard();
            return;
        }
    }
}

