/*
 * Decompiled with CFR 0.152.
 */
package net.night.throwable_spear.handler;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.night.throwable_spear.entity.CopperSpearEntity;
import net.night.throwable_spear.entity.DiamondSpearEntity;
import net.night.throwable_spear.entity.GoldenSpearEntity;
import net.night.throwable_spear.entity.IronSpearEntity;
import net.night.throwable_spear.entity.NetheriteSpearEntity;
import net.night.throwable_spear.entity.StoneSpearEntity;
import net.night.throwable_spear.entity.WoodenSpearEntity;

public class SpearHandler {
    public static void throwWoodenSpear(Player player) {
        if (player == null) {
            return;
        }
        Level level = player.level();
        if (level == null || level.isClientSide()) {
            return;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (mainHandItem.is(Items.WOODEN_SPEAR)) {
            if (!player.getAbilities().instabuild && mainHandItem.isDamageableItem()) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            WoodenSpearEntity spear = new WoodenSpearEntity(level, (LivingEntity)player, mainHandItem.copy());
            spear.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 0.0f);
            level.addFreshEntity((Entity)spear);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                mainHandItem.shrink(1);
            }
        } else if (mainHandItem.is(Items.STONE_SPEAR)) {
            if (!player.getAbilities().instabuild && mainHandItem.isDamageableItem()) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            StoneSpearEntity spearEntity = new StoneSpearEntity(level, (LivingEntity)player, mainHandItem.copy());
            spearEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
            level.addFreshEntity((Entity)spearEntity);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                mainHandItem.shrink(1);
            }
        } else if (mainHandItem.is(Items.COPPER_SPEAR)) {
            if (!player.getAbilities().instabuild && mainHandItem.isDamageableItem()) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            CopperSpearEntity spearEntity = new CopperSpearEntity(level, (LivingEntity)player, mainHandItem.copy());
            spearEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
            level.addFreshEntity((Entity)spearEntity);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                mainHandItem.shrink(1);
            }
        } else if (mainHandItem.is(Items.IRON_SPEAR)) {
            if (!player.getAbilities().instabuild && mainHandItem.isDamageableItem()) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            IronSpearEntity spearEntity = new IronSpearEntity(level, (LivingEntity)player, mainHandItem.copy());
            spearEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
            level.addFreshEntity((Entity)spearEntity);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                mainHandItem.shrink(1);
            }
        } else if (mainHandItem.is(Items.GOLDEN_SPEAR)) {
            if (!player.getAbilities().instabuild && mainHandItem.isDamageableItem()) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            GoldenSpearEntity spearEntity = new GoldenSpearEntity(level, (LivingEntity)player, mainHandItem.copy());
            spearEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
            level.addFreshEntity((Entity)spearEntity);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                mainHandItem.shrink(1);
            }
        } else if (mainHandItem.is(Items.DIAMOND_SPEAR)) {
            if (!player.getAbilities().instabuild && mainHandItem.isDamageableItem()) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            DiamondSpearEntity spearEntity = new DiamondSpearEntity(level, (LivingEntity)player, mainHandItem.copy());
            spearEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
            level.addFreshEntity((Entity)spearEntity);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                mainHandItem.shrink(1);
            }
        } else if (mainHandItem.is(Items.NETHERITE_SPEAR)) {
            if (!player.getAbilities().instabuild && mainHandItem.isDamageableItem()) {
                mainHandItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            NetheriteSpearEntity spearEntity = new NetheriteSpearEntity(level, (LivingEntity)player, mainHandItem.copy());
            spearEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
            level.addFreshEntity((Entity)spearEntity);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                mainHandItem.shrink(1);
            }
        }
    }
}

