/*
 * Decompiled with CFR 0.152.
 */
package net.night.throwable_spear.mixin;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public class EnchantmentMixin {
    @Unique
    private boolean throwableSpear$isAnySpear(ItemStack stack) {
        return stack.is(Items.WOODEN_SPEAR) || stack.is(Items.STONE_SPEAR) || stack.is(Items.COPPER_SPEAR) || stack.is(Items.IRON_SPEAR) || stack.is(Items.GOLDEN_SPEAR) || stack.is(Items.DIAMOND_SPEAR) || stack.is(Items.NETHERITE_SPEAR);
    }

    @Inject(method={"canEnchant(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void allowSpearEnchantments(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (!this.throwableSpear$isAnySpear(stack)) {
            return;
        }
        Enchantment thisEnchantment = (Enchantment)this;
        ItemStack tridentStack = new ItemStack((ItemLike)Items.TRIDENT);
        if (thisEnchantment.canEnchant(tridentStack)) {
            cir.setReturnValue((Object)true);
            return;
        }
        ItemStack swordStack = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
        if (thisEnchantment.canEnchant(swordStack)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isPrimaryItem(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")}, cancellable=true, require=0)
    private void makeAllSpearsPrimaryForWeaponEnchants(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (this.throwableSpear$isAnySpear(stack)) {
            Enchantment thisEnchantment = (Enchantment)this;
            if (thisEnchantment.isPrimaryItem(new ItemStack((ItemLike)Items.TRIDENT))) {
                cir.setReturnValue((Object)true);
                return;
            }
            if (thisEnchantment.isPrimaryItem(new ItemStack((ItemLike)Items.DIAMOND_SWORD))) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"isSupportedItem(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")}, cancellable=true, require=0)
    private void makeAllSpearsSupportedForWeaponEnchants(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (this.throwableSpear$isAnySpear(stack)) {
            Enchantment thisEnchantment = (Enchantment)this;
            if (thisEnchantment.isSupportedItem(new ItemStack((ItemLike)Items.TRIDENT))) {
                cir.setReturnValue((Object)true);
                return;
            }
            if (thisEnchantment.isSupportedItem(new ItemStack((ItemLike)Items.DIAMOND_SWORD))) {
                cir.setReturnValue((Object)true);
            }
        }
    }
}

