/*
 * Decompiled with CFR 0.152.
 */
package net.night.throwable_spear.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.night.throwable_spear.client.Throwable_spearClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public class MouseHandlerMixin {
    @Inject(method={"onScroll(JDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseScroll(long window, double xOffset, double yOffset, CallbackInfo ci) {
        if (yOffset > 0.0 && this.throwableSpear$isThrowingSpear()) {
            boolean shouldThrow = this.throwableSpear$shouldThrowSpear();
            Throwable_spearClient.onMouseScroll(yOffset);
            if (shouldThrow) {
                ci.cancel();
            }
        }
    }

    @Unique
    private boolean throwableSpear$isThrowingSpear() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return false;
        }
        ItemStack mainHand = minecraft.player.getMainHandItem();
        return mainHand.is(Items.WOODEN_SPEAR) || mainHand.is(Items.STONE_SPEAR) || mainHand.is(Items.COPPER_SPEAR) || mainHand.is(Items.IRON_SPEAR) || mainHand.is(Items.GOLDEN_SPEAR) || mainHand.is(Items.DIAMOND_SPEAR) || mainHand.is(Items.NETHERITE_SPEAR);
    }

    @Unique
    private boolean throwableSpear$shouldThrowSpear() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return false;
        }
        ItemStack mainHand = minecraft.player.getMainHandItem();
        return minecraft.options.keyUse.isDown() && (mainHand.is(Items.WOODEN_SPEAR) || mainHand.is(Items.STONE_SPEAR) || mainHand.is(Items.COPPER_SPEAR) || mainHand.is(Items.IRON_SPEAR) || mainHand.is(Items.GOLDEN_SPEAR) || mainHand.is(Items.DIAMOND_SPEAR) || mainHand.is(Items.NETHERITE_SPEAR));
    }
}

