/*
 * Decompiled with CFR 0.152.
 */
package net.night.throwable_spear.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_9109;
import net.night.throwable_spear.config.SpearConfig;
import net.night.throwable_spear.registry.ModEntities;

public class WoodenSpearEntity
extends class_1676 {
    private static final class_2940<Boolean> IN_GROUND = class_2945.method_12791(WoodenSpearEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ID_FOIL = class_2945.method_12791(WoodenSpearEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> ID_LOYALTY = class_2945.method_12791(WoodenSpearEntity.class, (class_2941)class_2943.field_13319);
    private class_1799 spearItem = new class_1799((class_1935)class_1802.field_63384);
    private boolean dealtDamage = false;
    private boolean noPhysics = false;
    public int clientSideReturnSpearTickCount = 0;
    private boolean rotationFrozen = false;

    public WoodenSpearEntity(class_1299<? extends WoodenSpearEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public WoodenSpearEntity(class_1937 level, class_1309 shooter, class_1799 spearItem) {
        super((class_1299)ModEntities.WOODEN_SPEAR_ENTITY.get(), level);
        this.method_7432((class_1297)shooter);
        this.spearItem = spearItem.method_7972();
        this.field_6011.method_12778(ID_FOIL, (Object)spearItem.method_7958());
        this.field_6011.method_12778(ID_LOYALTY, (Object)this.getLoyaltyFromItem(spearItem));
        class_243 eyePos = shooter.method_33571();
        class_243 lookVector = shooter.method_5720();
        double offsetDistance = 0.5;
        this.method_5814(eyePos.field_1352 + lookVector.field_1352 * offsetDistance, eyePos.field_1351 + 0.3, eyePos.field_1350 + lookVector.field_1350 * offsetDistance);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(IN_GROUND, (Object)false);
        builder.method_56912(ID_FOIL, (Object)false);
        builder.method_56912(ID_LOYALTY, (Object)0);
    }

    public void method_5773() {
        boolean inGround = (Boolean)this.field_6011.method_12789(IN_GROUND);
        if (inGround && !this.dealtDamage) {
            this.dealtDamage = true;
        }
        class_1297 owner = this.method_24921();
        byte loyalty = (Byte)this.field_6011.method_12789(ID_LOYALTY);
        if (loyalty > 0 && (this.dealtDamage || this.noPhysics) && owner != null) {
            if (!this.isAcceptibleReturnOwner()) {
                class_1937 class_19372;
                if (!this.method_73183().method_8608() && (class_19372 = this.method_73183()) instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    this.method_5775(serverLevel, this.spearItem.method_7972());
                    this.method_31472();
                }
            } else {
                this.noPhysics = true;
                if (!this.rotationFrozen) {
                    this.rotationFrozen = true;
                }
                class_243 ownerEyePos = owner.method_33571();
                class_243 currentSpearPos = this.method_73189();
                class_243 toOwner = ownerEyePos.method_1020(currentSpearPos);
                double acceleration = 0.05 * (double)loyalty;
                class_243 directionToOwner = toOwner.method_1029();
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(directionToOwner.method_1021(acceleration)));
                if (this.method_73183().method_8608() && this.clientSideReturnSpearTickCount == 0) {
                    this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
                if (owner instanceof class_1657) {
                    class_1657 player = (class_1657)owner;
                    if (this.method_5858(owner) < 4.0 && player.method_31548().method_7394(this.spearItem.method_7972())) {
                        this.method_5783(class_3417.field_15197, 1.0f, 1.0f);
                        this.method_31472();
                    }
                }
            }
            class_243 newPos = this.method_73189().method_1019(this.method_18798());
            this.method_33574(newPos);
            if (this.method_73183().method_8608()) {
                this.field_6038 = this.method_23317();
                this.field_5971 = this.method_23318();
                this.field_5989 = this.method_23321();
            }
            super.method_5773();
            return;
        }
        super.method_5773();
        if (loyalty > 0 && (this.dealtDamage || this.noPhysics) && owner != null && this.isAcceptibleReturnOwner()) {
            return;
        }
        if (inGround) {
            this.method_18799(class_243.field_1353);
            this.method_5875(true);
            if (!this.method_73183().method_8608()) {
                this.checkPlayerPickup();
            }
            return;
        }
        class_243 currentPos = this.method_73189();
        class_243 motion = this.method_18798();
        motion = motion.method_1031(0.0, -0.03, 0.0);
        motion = motion.method_1021(0.99);
        class_243 nextPos = currentPos.method_1019(motion);
        class_238 searchBox = this.method_5829().method_18804(motion).method_1014(1.0);
        List entities = this.method_73183().method_8333((class_1297)this, searchBox, entity -> !entity.method_7325() && entity.method_5863() && entity != this.method_24921());
        class_3966 entityHit = null;
        double closestDistance = Double.MAX_VALUE;
        for (class_1297 entity2 : entities) {
            double distance;
            class_238 entityBox = entity2.method_5829().method_1014(0.3);
            Optional optional = entityBox.method_992(currentPos, nextPos);
            if (!optional.isPresent() || !((distance = currentPos.method_1025((class_243)optional.get())) < closestDistance)) continue;
            closestDistance = distance;
            entityHit = new class_3966(entity2, (class_243)optional.get());
        }
        if (entityHit != null) {
            this.method_7454(entityHit);
            return;
        }
        if (!this.noPhysics) {
            class_243 extendedNextPos = currentPos.method_1019(motion.method_1021(1.5));
            class_3965 blockHit = this.method_73183().method_17742(new class_3959(currentPos, extendedNextPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (blockHit.method_17783() != class_239.class_240.field_1333) {
                class_243 hitLoc = blockHit.method_17784();
                class_2350 dir = blockHit.method_17780();
                double penetrationDepth = dir == class_2350.field_11036 ? -0.1 : (dir == class_2350.field_11033 ? -0.15 : -0.2);
                class_243 normal = new class_243((double)dir.method_10148(), (double)dir.method_10164(), (double)dir.method_10165());
                class_243 finalPos = hitLoc.method_1019(normal.method_1021(penetrationDepth));
                this.method_33574(finalPos);
                this.method_18799(class_243.field_1353);
                this.method_5875(true);
                this.field_6011.method_12778(IN_GROUND, (Object)true);
                this.method_5783(class_3417.field_15104, 1.0f, 1.0f);
                return;
            }
        }
        this.method_33574(nextPos);
        this.method_18799(motion);
        this.method_26962();
    }

    protected void method_26962() {
        if (this.rotationFrozen) {
            return;
        }
        class_243 motion = this.method_18798();
        double horizontalDist = motion.method_37267();
        if (horizontalDist > 0.001) {
            float yaw = (float)(class_3532.method_15349((double)motion.field_1352, (double)motion.field_1350) * 57.29577951308232);
            this.method_36456(yaw);
            float pitch = (float)(class_3532.method_15349((double)motion.field_1351, (double)horizontalDist) * 57.29577951308232);
            this.method_36457(pitch);
        }
    }

    protected void method_7454(class_3966 result) {
        if (this.method_73183().method_8608()) {
            return;
        }
        class_1297 class_12972 = result.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            class_12972 = this.method_73183();
            if (class_12972 instanceof class_3218) {
                float finalDamage;
                class_3218 serverLevel = (class_3218)class_12972;
                float baseDamage = SpearConfig.getInstance().woodenSpearDamage;
                class_1282 damageSource = this.method_48923().method_48811((class_1297)this, this.method_24921());
                boolean hitSuccess = target.method_64397(serverLevel, damageSource, finalDamage = class_1890.method_60120((class_3218)serverLevel, (class_1799)this.spearItem, (class_1297)target, (class_1282)damageSource, (float)baseDamage));
                if (hitSuccess) {
                    this.dealtDamage = true;
                    class_1890.method_60619((class_3218)serverLevel, (class_1297)target, (class_1282)damageSource, (class_1799)this.spearItem);
                    class_243 knockbackDirection = this.method_18798().method_1029();
                    target.method_6005(0.1, -knockbackDirection.field_1352, -knockbackDirection.field_1350);
                    if (this.spearItem.method_7963()) {
                        this.spearItem.method_7956(1, serverLevel, this.method_24921() instanceof class_3222 ? (class_3222)this.method_24921() : null, item -> {
                            this.method_31472();
                            this.method_5783((class_3414)class_3417.field_15075.comp_349(), 1.0f, 1.0f);
                        });
                    }
                    this.method_5783(class_3417.field_15213, 1.0f, 1.0f);
                    class_243 impactMotion = this.method_18798();
                    float impactHorizontalDist = (float)impactMotion.method_37267();
                    this.method_18799(impactMotion.method_18805(0.02, 0.1, 0.02));
                    byte loyalty = (Byte)this.field_6011.method_12789(ID_LOYALTY);
                    if (loyalty > 0) {
                        this.rotationFrozen = true;
                    } else {
                        float finalYaw = (float)(class_3532.method_15349((double)impactMotion.field_1352, (double)impactMotion.field_1350) * 180.0 / Math.PI) + 180.0f;
                        float finalPitch = (float)(class_3532.method_15349((double)(-impactMotion.field_1351), (double)impactHorizontalDist) * 180.0 / Math.PI) + 15.0f;
                        this.method_36456(finalYaw);
                        this.method_36457(finalPitch);
                        this.field_5982 = finalYaw;
                        this.field_6004 = finalPitch;
                        this.rotationFrozen = true;
                    }
                }
            }
        }
    }

    protected void method_24920(class_3965 result) {
    }

    public boolean method_5640(double distance) {
        return distance < 4096.0;
    }

    protected class_9109 method_59860(class_239 result) {
        return class_9109.field_48347;
    }

    public class_1799 method_59958() {
        return this.spearItem;
    }

    public boolean isFoil() {
        return (Boolean)this.field_6011.method_12789(ID_FOIL);
    }

    private byte getLoyaltyFromItem(class_1799 stack) {
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return (byte)class_1890.method_60169((class_3218)serverLevel, (class_1799)stack, (class_1297)this);
        }
        return 0;
    }

    private boolean isAcceptibleReturnOwner() {
        class_1297 entity = this.method_24921();
        if (entity == null || !entity.method_5805()) {
            return false;
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            return !serverPlayer.method_7325();
        }
        return true;
    }

    public class_4048 method_18377(class_4050 pose) {
        return class_4048.method_18384((float)0.5f, (float)0.5f);
    }

    private void checkPlayerPickup() {
        if (this.method_73183().method_8608()) {
            return;
        }
        class_238 searchBox = this.method_5829().method_1014(2.5);
        List nearbyPlayers = this.method_73183().method_18467(class_1657.class, searchBox);
        for (class_1657 player : nearbyPlayers) {
            double distance = player.method_5858((class_1297)this);
            if (!(distance < 5.5) || !player.method_31548().method_7394(this.spearItem.method_7972())) continue;
            this.method_73183().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15197, class_3419.field_15248, 1.0f, ((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.7f + 1.0f) * 2.0f);
            this.method_31472();
            return;
        }
    }
}

