/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.betterx.bclib.api.v2.dataexchange.BCLibPayload;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;
import org.betterx.bclib.api.v2.dataexchange.PacketSender;

public final class BCLibNetwork {
    private BCLibNetwork() {
    }

    public static void init() {
    }

    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("bclib");
        registrar.playBidirectional(BCLibPayload.TYPE, BCLibPayload.STREAM_CODEC, BCLibNetwork::handleBidirectional);
    }

    public static void sendToServer(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)BCLibPayload.from(payload), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(ServerPlayer player, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)BCLibPayload.from(payload), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void handleFromClient(BCLibPayload message, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        context.enqueueWork(() -> {
            CustomPacketPayload payload = message.toPayload();
            if (payload == null) {
                return;
            }
            DataHandlerDescriptor descriptor = DataExchangeAPI.getDescriptor(message.id());
            if (descriptor == null) {
                return;
            }
            descriptor.receiveFromClient(payload, new ServerPacketSender(player2), player2);
        });
    }

    private static void handleFromServer(BCLibPayload message, IPayloadContext context) {
        context.enqueueWork(() -> {
            CustomPacketPayload payload = message.toPayload();
            if (payload == null) {
                return;
            }
            DataHandlerDescriptor descriptor = DataExchangeAPI.getDescriptor(message.id());
            if (descriptor == null) {
                return;
            }
            descriptor.receiveFromServer(payload, ClientPacketSender.INSTANCE, Minecraft.getInstance());
        });
    }

    private static void handleBidirectional(BCLibPayload message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            BCLibNetwork.handleFromClient(message, context);
        } else {
            BCLibNetwork.handleFromServer(message, context);
        }
    }

    private static final class ClientPacketSender
    implements PacketSender {
        private static final ClientPacketSender INSTANCE = new ClientPacketSender();

        private ClientPacketSender() {
        }

        @Override
        public void send(CustomPacketPayload payload) {
            BCLibNetwork.sendToServer(payload);
        }
    }

    private static final class ServerPacketSender
    implements PacketSender {
        private final ServerPlayer player;

        private ServerPacketSender(ServerPlayer player) {
            this.player = player;
        }

        @Override
        public void send(CustomPacketPayload payload) {
            BCLibNetwork.sendToPlayer(this.player, payload);
        }
    }
}

