/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;

public final class BCLibPayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<BCLibPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"bclib", (String)"dataexchange"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BCLibPayload> STREAM_CODEC = StreamCodec.of((buf, payload) -> BCLibPayload.encode(payload, (FriendlyByteBuf)buf), buf -> BCLibPayload.decode((FriendlyByteBuf)buf));
    private final ResourceLocation id;
    private final byte[] data;

    public BCLibPayload(ResourceLocation id, byte[] data) {
        this.id = id;
        this.data = data;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public byte[] data() {
        return this.data;
    }

    public CustomPacketPayload.Type<BCLibPayload> type() {
        return TYPE;
    }

    public static BCLibPayload from(CustomPacketPayload payload) {
        DataHandlerDescriptor descriptor = DataExchangeAPI.getDescriptor(payload.type().id());
        if (descriptor == null) {
            throw new IllegalStateException("Missing payload descriptor for " + String.valueOf(payload.type().id()));
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        StreamCodec codec = descriptor.STREAM_CODEC;
        codec.encode((Object)buffer, (Object)((DataHandlerDescriptor.PacketPayload)payload));
        byte[] data = new byte[buffer.readableBytes()];
        buffer.readBytes(data);
        return new BCLibPayload(descriptor.IDENTIFIER.id(), data);
    }

    public CustomPacketPayload toPayload() {
        DataHandlerDescriptor descriptor = DataExchangeAPI.getDescriptor(this.id);
        if (descriptor == null) {
            return null;
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.data));
        return (CustomPacketPayload)descriptor.STREAM_CODEC.decode((Object)buffer);
    }

    public static void encode(BCLibPayload payload, FriendlyByteBuf buf) {
        buf.writeResourceLocation(payload.id);
        buf.writeByteArray(payload.data);
    }

    public static BCLibPayload decode(FriendlyByteBuf buf) {
        ResourceLocation id = buf.readResourceLocation();
        byte[] data = buf.readByteArray();
        return new BCLibPayload(id, data);
    }
}

