/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.betterx.bclib.api.v2.dataexchange.PacketSender;
import org.betterx.bclib.api.v2.dataexchange.handler.DataExchange;
import org.jetbrains.annotations.NotNull;

public class DataHandlerDescriptor<T extends PacketPayload<T>> {
    public final Direction DIRECTION;
    @NotNull
    public final StreamCodec<FriendlyByteBuf, T> STREAM_CODEC;
    public final boolean sendOnJoin;
    public final boolean sendBeforeEnter;
    @NotNull
    public final PayloadFactory<T> PAYLOAD_FACTORY;
    @NotNull
    public final CustomPacketPayload.Type<T> IDENTIFIER;
    @NotNull
    public final Supplier<BaseDataHandler<T>> INSTANCE;
    @NotNull
    public final Supplier<BaseDataHandler<T>> JOIN_INSTANCE;

    public DataHandlerDescriptor(@NotNull Direction direction, @NotNull ResourceLocation identifier, @NotNull PayloadFactory<T> factory, @NotNull Supplier<BaseDataHandler<T>> instancer) {
        this(direction, identifier, factory, instancer, instancer, false, false);
    }

    public DataHandlerDescriptor(@NotNull Direction direction, @NotNull ResourceLocation identifier, @NotNull PayloadFactory<T> factory, @NotNull Supplier<BaseDataHandler<T>> instancer, boolean sendOnJoin, boolean sendBeforeEnter) {
        this(direction, identifier, factory, instancer, instancer, sendOnJoin, sendBeforeEnter);
    }

    public DataHandlerDescriptor(@NotNull Direction direction, @NotNull ResourceLocation identifier, @NotNull PayloadFactory<T> factory, @NotNull Supplier<BaseDataHandler<T>> receiv_instancer, @NotNull Supplier<BaseDataHandler<T>> join_instancer, boolean sendOnJoin, boolean sendBeforeEnter) {
        this.DIRECTION = direction;
        this.INSTANCE = receiv_instancer;
        this.JOIN_INSTANCE = join_instancer;
        this.IDENTIFIER = new CustomPacketPayload.Type(identifier);
        this.sendOnJoin = sendOnJoin;
        this.sendBeforeEnter = sendBeforeEnter;
        this.PAYLOAD_FACTORY = factory;
        this.STREAM_CODEC = CustomPacketPayload.codec(PacketPayload::write, factory::create);
        DataExchange.registerDescriptor(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ResourceLocation) {
            return o.equals(this.IDENTIFIER);
        }
        if (!(o instanceof DataHandlerDescriptor)) {
            return false;
        }
        DataHandlerDescriptor that = (DataHandlerDescriptor)o;
        return this.IDENTIFIER.equals(that.IDENTIFIER);
    }

    public int hashCode() {
        return Objects.hash(this.IDENTIFIER);
    }

    void receiveFromServer(Object payload, PacketSender responseSender, Minecraft client) {
        BaseDataHandler<PacketPayload> h = this.INSTANCE.get();
        h.receiveFromServer(client, client.getConnection(), (PacketPayload)payload, responseSender);
    }

    void receiveFromClient(Object payload, PacketSender responseSender, ServerPlayer player) {
        BaseDataHandler<PacketPayload> h = this.INSTANCE.get();
        h.receiveFromClient(player.server, player, player.connection, (PacketPayload)payload, responseSender);
    }

    public static enum Direction {
        CLIENT_TO_SERVER,
        SERVER_TO_CLIENT;

    }

    public static interface PayloadFactory<T extends PacketPayload<T>> {
        public T create(FriendlyByteBuf var1);
    }

    public static abstract class PacketPayload<T extends PacketPayload<T>>
    implements CustomPacketPayload {
        protected final DataHandlerDescriptor<T> descriptor;

        protected PacketPayload(DataHandlerDescriptor<T> desc) {
            this.descriptor = desc;
        }

        protected abstract void write(FriendlyByteBuf var1);

        @NotNull
        public final CustomPacketPayload.Type<T> type() {
            return this.descriptor.IDENTIFIER;
        }
    }
}

