/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.betterx.bclib.api.v2.dataexchange.BCLibNetwork;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.betterx.bclib.api.v2.dataexchange.Connector;
import org.betterx.bclib.api.v2.dataexchange.ConnectorServerside;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;

@EventBusSubscriber(modid="bclib", bus=EventBusSubscriber.Bus.GAME)
public abstract class DataExchange {
    private static DataExchangeAPI instance;
    protected ConnectorServerside server;
    protected Connector client;
    protected final Set<DataHandlerDescriptor> descriptors = new HashSet<DataHandlerDescriptor>();
    private final boolean didLoadSyncFolder = false;

    protected static DataExchangeAPI getInstance() {
        if (instance == null) {
            instance = new DataExchangeAPI();
        }
        return instance;
    }

    protected abstract Connector clientSupplier(DataExchange var1);

    protected abstract ConnectorServerside serverSupplier(DataExchange var1);

    protected DataExchange() {
    }

    public Set<DataHandlerDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public static DataHandlerDescriptor getDescriptor(ResourceLocation identifier) {
        return DataExchange.getInstance().descriptors.stream().filter(d -> d.equals(identifier)).findFirst().orElse(null);
    }

    public static void registerDescriptor(DataHandlerDescriptor descriptor) {
        DataExchange.getInstance().descriptors.add(descriptor);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void initClientside() {
        if (this.client != null) {
            return;
        }
        this.client = this.clientSupplier(this);
    }

    protected void initServerSide() {
        if (this.server != null) {
            return;
        }
        this.server = this.serverSupplier(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void prepareClientside() {
        DataExchangeAPI api = DataExchange.getInstance();
        BCLibNetwork.init();
        api.initClientside();
    }

    public static void prepareServerside() {
        DataExchangeAPI api = DataExchange.getInstance();
        BCLibNetwork.init();
        api.initServerSide();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendOnEnter() {
        DataExchange.getInstance().descriptors.forEach(desc -> {
            BaseDataHandler h;
            if (desc.sendBeforeEnter && !(h = desc.JOIN_INSTANCE.get()).getOriginatesOnServer()) {
                DataExchange.getInstance().client.sendToServer(h);
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        DataExchangeAPI api = DataExchange.getInstance();
        api.initServerSide();
        ServerPlayer player = (ServerPlayer)event.getEntity();
        api.server.onPlayInit(player.connection, player.server);
        api.server.onPlayReady(player.connection, player.server);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        DataExchangeAPI api = DataExchange.getInstance();
        ServerPlayer player = (ServerPlayer)event.getEntity();
        api.server.onPlayDisconnect(player.connection, player.server);
    }
}

