/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.StructureErode;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class TemplatePiece
extends TemplateStructurePiece {
    private final int erosion;
    private final boolean cover;
    public static final ResourceLocation ID = BCLib.makeID("template_piece");
    public static StructurePieceType INSTANCE;

    public static void register(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.STRUCTURE_PIECE)) {
            event.register(Registries.STRUCTURE_PIECE, helper -> {
                INSTANCE = (ctx, tag) -> new TemplatePiece(ctx.structureTemplateManager(), tag);
                helper.register(ID, (Object)INSTANCE);
            });
        }
    }

    public static void ensureStaticInitialization() {
    }

    public TemplatePiece(StructureTemplateManager structureTemplateManager, ResourceLocation resourceLocation, BlockPos centerPos, Rotation rotation, Mirror mirror, BlockPos halfSize) {
        this(structureTemplateManager, resourceLocation, centerPos, rotation, mirror, halfSize, 0, false);
    }

    public TemplatePiece(StructureTemplateManager structureTemplateManager, ResourceLocation resourceLocation, BlockPos centerPos, Rotation rotation, Mirror mirror, BlockPos halfSize, int erosion, boolean cover) {
        super(INSTANCE, 0, structureTemplateManager, resourceLocation, resourceLocation.toString(), TemplatePiece.makeSettings(rotation, mirror, halfSize), TemplatePiece.shiftPos(rotation, mirror, halfSize, centerPos));
        this.erosion = erosion;
        this.cover = cover;
    }

    public TemplatePiece(StructureTemplateManager structureTemplateManager, CompoundTag compoundTag) {
        super(INSTANCE, compoundTag, structureTemplateManager, resourceLocation -> TemplatePiece.makeSettings(compoundTag));
        this.erosion = compoundTag.contains("E") ? compoundTag.getInt("E") : 0;
        this.cover = compoundTag.contains("C") ? compoundTag.getBoolean("C") : true;
    }

    private static BlockPos shiftPos(Rotation rotation, Mirror mirror, BlockPos halfSize, BlockPos pos) {
        halfSize = StructureTemplate.transform((BlockPos)halfSize, (Mirror)mirror, (Rotation)rotation, (BlockPos)halfSize);
        return pos.offset(-halfSize.getX(), 0, -halfSize.getZ());
    }

    private static StructurePlaceSettings makeSettings(CompoundTag compoundTag) {
        return TemplatePiece.makeSettings(Rotation.valueOf((String)compoundTag.getString("R")), Mirror.valueOf((String)compoundTag.getString("M")), new BlockPos(compoundTag.getInt("RX"), compoundTag.getInt("RY"), compoundTag.getInt("RZ")));
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation, Mirror mirror, BlockPos halfSize) {
        return new StructurePlaceSettings().setRotation(rotation).setMirror(mirror).setRotationPivot(halfSize).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        super.addAdditionalSaveData(structurePieceSerializationContext, tag);
        tag.putString("R", this.placeSettings.getRotation().name());
        tag.putString("M", this.placeSettings.getMirror().name());
        tag.putInt("RX", this.placeSettings.getRotationPivot().getX());
        tag.putInt("RY", this.placeSettings.getRotationPivot().getY());
        tag.putInt("RZ", this.placeSettings.getRotationPivot().getZ());
        tag.putInt("E", this.erosion);
        tag.putBoolean("C", this.cover);
    }

    protected void handleDataMarker(String string, BlockPos blockPos, ServerLevelAccessor serverLevelAccessor, RandomSource randomSource, BoundingBox boundingBox) {
    }

    public void postProcess(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.MutableBlockPos mPos;
        BlockState coverState = null;
        if (this.cover && BlocksHelper.findOnSurroundingSurface((LevelAccessor)world, mPos = new BlockPos(this.boundingBox.minX() - 1, blockPos.getY(), this.boundingBox.minZ() - 1).mutable(), Direction.DOWN, 8, s -> s.is(CommonBlockTags.TERRAIN))) {
            mPos.move(Direction.DOWN);
            coverState = world.getBlockState((BlockPos)mPos);
        }
        super.postProcess(world, structureManager, chunkGenerator, random, boundingBox, chunkPos, blockPos);
        BoundingBox bounds = BoundingBox.fromCorners((Vec3i)new Vec3i(boundingBox.minX(), this.boundingBox.minY(), boundingBox.minZ()), (Vec3i)new Vec3i(boundingBox.maxX(), this.boundingBox.maxY(), boundingBox.maxZ()));
        if (this.erosion > 0) {
            int x1 = MHelper.min(bounds.maxX(), this.boundingBox.maxX());
            int x0 = MHelper.max(bounds.minX(), this.boundingBox.minX());
            int z1 = MHelper.min(bounds.maxZ(), this.boundingBox.maxZ());
            int z0 = MHelper.max(bounds.minZ(), this.boundingBox.minZ());
            bounds = BoundingBox.fromCorners((Vec3i)new Vec3i(x0, bounds.minY(), z0), (Vec3i)new Vec3i(x1, bounds.maxY(), z1));
            StructureErode.erode(world, bounds, this.erosion, random);
        }
        if (this.cover) {
            StructureErode.cover(world, bounds, random, coverState);
        }
    }
}

