/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.datagen;

import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.betterx.bclib.api.v2.advancement.AdvancementManager;

public abstract class AdvancementDataProvider
implements DataProvider {
    protected final List<String> modIDs;
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;

    protected AdvancementDataProvider(List<String> modIDs, PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup) {
        this.modIDs = modIDs;
        this.pathProvider = output.createRegistryElementsPathProvider(Registries.ADVANCEMENT);
        this.registries = registryLookup;
    }

    protected abstract void bootstrap(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(lookup -> {
            this.bootstrap((HolderLookup.Provider)lookup);
            HashSet seen = new HashSet();
            ArrayList futures = new ArrayList();
            Consumer<AdvancementHolder> consumer = holder -> {
                if (!seen.add(holder.id())) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(holder.id()));
                }
                futures.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)lookup, (Codec)Advancement.CODEC, (Object)holder.value(), (Path)this.pathProvider.json(holder.id())));
            };
            AdvancementManager.registerAllDataGen(this.modIDs, consumer);
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Advancements";
    }
}

