/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.datagen;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v3.datagen.DatapackRecipeBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class RecipeDataProvider
extends RecipeProvider {
    private static List<DatapackRecipeBuilder> RECIPES;
    @Nullable
    protected final List<String> modIDs;

    public RecipeDataProvider(@Nullable List<String> modIDs, PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
        this.modIDs = modIDs;
    }

    public void buildRecipes(RecipeOutput exporter) {
        if (RECIPES == null) {
            return;
        }
        for (DatapackRecipeBuilder r : RECIPES) {
            if (this.modIDs != null && !this.modIDs.isEmpty() && !this.modIDs.contains(r.getNamespace())) continue;
            r.build(exporter);
        }
    }

    @ApiStatus.Internal
    public static void register(DatapackRecipeBuilder builder) {
        if (!BCLib.isDatagen()) {
            return;
        }
        if (RECIPES == null) {
            RECIPES = new ArrayList<DatapackRecipeBuilder>();
        }
        RECIPES.add(builder);
    }
}

