/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.behaviours;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class BehaviourBuilders {
    public static BlockBehaviour.Properties createPlant() {
        return BehaviourBuilders.createPlant(MapColor.PLANT);
    }

    public static BlockBehaviour.Properties createPlant(MapColor color) {
        return BehaviourBuilders.createWalkablePlant(color).noCollission();
    }

    public static BlockBehaviour.Properties createWalkablePlant() {
        return BehaviourBuilders.createWalkablePlant(MapColor.PLANT);
    }

    public static BlockBehaviour.Properties createWalkablePlant(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).noOcclusion().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties createVine() {
        return BehaviourBuilders.createVine(MapColor.PLANT);
    }

    public static Item.Properties createDisc() {
        return new Item.Properties().stacksTo(1).rarity(Rarity.RARE);
    }

    public static BlockBehaviour.Properties createStaticVine(MapColor color) {
        return BehaviourBuilders.createPlant(color).replaceable().noCollission().strength(0.2f).sound(SoundType.VINE);
    }

    public static BlockBehaviour.Properties createVine(MapColor color) {
        return BehaviourBuilders.createStaticVine(color).randomTicks();
    }

    public static BlockBehaviour.Properties createGrass(MapColor color) {
        return BehaviourBuilders.createPlant(color).noCollission().noOcclusion().offsetType(BlockBehaviour.OffsetType.XZ).sound(SoundType.GRASS);
    }

    public static BlockBehaviour.Properties createSeed(MapColor color) {
        return BehaviourBuilders.createPlant(color).noCollission().randomTicks().sound(SoundType.HARD_CROP).offsetType(BlockBehaviour.OffsetType.XZ);
    }

    public static BlockBehaviour.Properties createPlantCover(MapColor color) {
        return BehaviourBuilders.createPlant(color).forceSolidOn().noCollission().replaceable().strength(0.2f).sound(SoundType.GLOW_LICHEN);
    }

    public static BlockBehaviour.Properties createWaterPlant() {
        return BehaviourBuilders.createWaterPlant(MapColor.WATER);
    }

    public static BlockBehaviour.Properties createWaterPlant(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).instabreak().noOcclusion().noCollission().sound(SoundType.WET_GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties createReplaceableWaterPlant() {
        return BehaviourBuilders.createWaterPlant().replaceable();
    }

    public static BlockBehaviour.Properties createLeaves() {
        return BehaviourBuilders.createLeaves(MapColor.PLANT, true);
    }

    public static BlockBehaviour.Properties createStaticLeaves() {
        return BehaviourBuilders.createStaticLeaves(MapColor.PLANT, true);
    }

    public static BlockBehaviour.Properties createStaticLeaves(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.of().mapColor(color).strength(0.2f).noOcclusion().isValidSpawn(Blocks::ocelotOrParrot).isSuffocating(Blocks::never).isViewBlocking(Blocks::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(Blocks::never).sound(SoundType.GRASS);
        if (flammable) {
            p.ignitedByLava();
        }
        return p;
    }

    public static BlockBehaviour.Properties createLeaves(MapColor color, boolean flammable) {
        return BehaviourBuilders.createStaticLeaves(color, flammable).randomTicks();
    }

    public static BlockBehaviour.Properties createCactus(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.of().mapColor(color).randomTicks().strength(0.4f).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY).noOcclusion();
        if (flammable) {
            p.ignitedByLava();
        }
        return p;
    }

    public static BlockBehaviour.Properties createMetal() {
        return BehaviourBuilders.createMetal(MapColor.METAL);
    }

    public static BlockBehaviour.Properties createMetal(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.IRON_XYLOPHONE).strength(5.0f, 6.0f).sound(SoundType.METAL);
    }

    public static BlockBehaviour.Properties createStone() {
        return BehaviourBuilders.createStone(MapColor.STONE);
    }

    public static BlockBehaviour.Properties createStone(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).strength(1.5f, 6.0f).instrument(NoteBlockInstrument.BASEDRUM);
    }

    public static BlockBehaviour.Properties createWood() {
        return BehaviourBuilders.createWood(MapColor.WOOD, true);
    }

    public static BlockBehaviour.Properties createWood(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD);
        if (flammable) {
            p.ignitedByLava();
        }
        return p;
    }

    public static BlockBehaviour.Properties createSign(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.of().mapColor(color).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f);
        if (flammable) {
            p.ignitedByLava();
        }
        return p;
    }

    public static BlockBehaviour.Properties createWallSign(MapColor color, Block dropBlock, boolean flammable) {
        return BehaviourBuilders.createSign(color, flammable).dropsLike(dropBlock);
    }

    public static BlockBehaviour.Properties createTrapDoor(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never);
        if (flammable) {
            p.ignitedByLava();
        }
        return p;
    }

    public static BlockBehaviour.Properties createGlass() {
        return BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.HAT).strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn(Blocks::never).isRedstoneConductor(Blocks::never).isSuffocating(Blocks::never).isViewBlocking(Blocks::never);
    }

    public static BlockBehaviour.Properties createSnow() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).requiresCorrectToolForDrops().strength(0.2f).sound(SoundType.SNOW);
    }
}

