/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBookshelfBlock
extends BaseBlock
implements BlockTagProvider,
BlockLootProvider,
BlockModelProvider {
    private final Block topBlock;

    protected BaseBookshelfBlock(Block topBlock) {
        this(topBlock, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)topBlock));
    }

    protected BaseBookshelfBlock(Block topBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.topBlock = topBlock;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createBookshelf((Block)this, this.topBlock);
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add((Object)this, new TagKey[]{CommonBlockTags.BOOKSHELVES});
    }

    @Override
    @Nullable
    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        return provider.dropWithSilkTouch((Block)this, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f));
    }

    public static BaseBookshelfBlock from(Block topBlock) {
        return new Wood(topBlock);
    }

    public static class Wood
    extends BaseBookshelfBlock
    implements BehaviourWood {
        public Wood(Block topBlock) {
            super(topBlock);
        }

        public Wood(Block topBlock, BlockBehaviour.Properties properties) {
            super(topBlock, properties);
        }
    }

    public static class VanillaWood
    extends Wood {
        public VanillaWood(Block topBlock) {
            super(topBlock);
        }
    }
}

