/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.BaseBarkBlock;
import org.betterx.bclib.interfaces.tools.AxeCanStrip;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BaseStripableBarkBlock
extends BaseBarkBlock
implements AxeCanStrip {
    private final Block strippedBlock;

    protected BaseStripableBarkBlock(Block strippedBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.strippedBlock = strippedBlock;
    }

    @Override
    public BlockState strippedState(BlockState state) {
        return this.strippedBlock.defaultBlockState();
    }

    public static class Wood
    extends BaseStripableBarkBlock
    implements BehaviourWood,
    BlockTagProvider,
    ItemTagProvider {
        private final boolean flammable;

        public Wood(MapColor color, Block strippedBlock, boolean flammable) {
            super(strippedBlock, (flammable ? BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)strippedBlock).ignitedByLava() : BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)strippedBlock)).mapColor(color));
            this.flammable = flammable;
        }

        public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
            context.add((Object)this, new TagKey[]{BlockTags.LOGS});
            if (this.flammable) {
                context.add((Object)this, new TagKey[]{BlockTags.LOGS_THAT_BURN});
            }
        }

        public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
            context.add((ItemLike)this, new TagKey[]{ItemTags.LOGS});
            if (this.flammable) {
                context.add((ItemLike)this, new TagKey[]{ItemTags.LOGS_THAT_BURN});
            }
        }
    }
}

