/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.core.Direction;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BaseTrapdoorBlock
extends TrapDoorBlock
implements RenderLayerProvider,
BlockModelProvider,
BlockTagProvider,
ItemTagProvider,
DropSelfLootProvider<BaseTrapdoorBlock> {
    protected BaseTrapdoorBlock(BlockBehaviour.Properties properties, BlockSetType type) {
        super(type, properties);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add((Object)this, new TagKey[]{BlockTags.TRAPDOORS});
    }

    public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
        context.add((ItemLike)this, new TagKey[]{ItemTags.TRAPDOORS});
    }

    private VariantProperties.Rotation xRotationForState(boolean isTop, boolean isOpen, Direction dir) {
        return isTop && isOpen ? VariantProperties.Rotation.R270 : (isTop ? VariantProperties.Rotation.R180 : (isOpen ? VariantProperties.Rotation.R90 : VariantProperties.Rotation.R0));
    }

    private VariantProperties.Rotation yRotationForState(boolean isTop, boolean isOpen, Direction dir) {
        VariantProperties.Rotation y = VariantProperties.Rotation.R0;
        switch (dir) {
            case EAST: {
                y = isTop && isOpen ? VariantProperties.Rotation.R270 : VariantProperties.Rotation.R90;
                break;
            }
            case NORTH: {
                if (!isTop || !isOpen) break;
                y = VariantProperties.Rotation.R180;
                break;
            }
            case SOUTH: {
                y = isTop && isOpen ? VariantProperties.Rotation.R0 : VariantProperties.Rotation.R180;
                break;
            }
            case WEST: {
                y = isTop && isOpen ? VariantProperties.Rotation.R90 : VariantProperties.Rotation.R270;
                break;
            }
        }
        return y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        ResourceLocation id = TextureMapping.getBlockTexture((Block)this);
        TextureMapping mapping = new TextureMapping().put(TextureSlot.TEXTURE, id).put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath().replace("_trapdoor", "")).withSuffix("_door_side"));
        ResourceLocation model = BCLModels.TRAPDOOR.create((Block)this, mapping, generator.modelOutput());
        PropertyDispatch.C3 props = PropertyDispatch.properties((Property)HALF, (Property)OPEN, (Property)FACING);
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        boolean[] open = new boolean[]{true, false};
        Half[] halfs = new Half[]{Half.TOP, Half.BOTTOM};
        for (Direction dir : directions) {
            for (Half half : halfs) {
                for (boolean isOpen : open) {
                    props.select((Comparable)half, (Comparable)Boolean.valueOf(isOpen), (Comparable)dir, Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.X_ROT, (Object)this.xRotationForState(half == Half.TOP, isOpen, dir)).with(VariantProperties.Y_ROT, (Object)this.yRotationForState(half == Half.TOP, isOpen, dir)));
                }
            }
        }
        generator.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)this).with((PropertyDispatch)props));
    }

    public static BaseTrapdoorBlock from(Block source, BlockSetType type, boolean flammable) {
        return BehaviourHelper.from(source, type, (s, t) -> new Wood((Block)s, (BlockSetType)t, flammable), Stone::new, Metal::new);
    }

    public static class Wood
    extends BaseTrapdoorBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type, boolean flammable) {
            this(BehaviourBuilders.createTrapDoor(source.defaultMapColor(), flammable).sound(SoundType.WOOD), type);
        }

        public Wood(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }

        @Override
        public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
            context.add((Object)this, new TagKey[]{BlockTags.TRAPDOORS, BlockTags.WOODEN_TRAPDOORS});
        }

        @Override
        public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
            context.add((ItemLike)this, new TagKey[]{ItemTags.TRAPDOORS, ItemTags.WOODEN_TRAPDOORS});
        }
    }

    public static class Metal
    extends BaseTrapdoorBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            this(BehaviourBuilders.createTrapDoor(source.defaultMapColor(), false).sound(SoundType.METAL), type);
        }

        public Metal(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }

    public static class Stone
    extends BaseTrapdoorBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            this(BehaviourBuilders.createTrapDoor(source.defaultMapColor(), false).sound(SoundType.STONE), type);
        }

        public Stone(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }
}

