/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.AbstractVineBlock;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.wover.block.api.BlockProperties;

public class BaseVineBlock
extends AbstractVineBlock {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public BaseVineBlock() {
        this(0, false);
    }

    public BaseVineBlock(int light) {
        this(light, false);
    }

    public BaseVineBlock(int light, boolean onlyBottomIsLit) {
        this(light, onlyBottomIsLit, p -> p);
    }

    public BaseVineBlock(int light, boolean onlyBottomIsLit, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> propMod) {
        this(propMod.apply(BehaviourBuilders.createPlant().sound(SoundType.GRASS).lightLevel(state -> onlyBottomIsLit ? (state.getValue(SHAPE) == BlockProperties.TripleShape.BOTTOM ? light : 0) : light).offsetType(BlockBehaviour.OffsetType.XZ)), 32, 0);
    }

    public BaseVineBlock(BlockBehaviour.Properties properties, int maxGrowLength, int spaceBeneath) {
        this(properties, maxGrowLength, spaceBeneath, 0);
    }

    private BaseVineBlock(BlockBehaviour.Properties properties, int maxGrowLength, int spaceBeneath, int growChance) {
        super(properties, maxGrowLength, spaceBeneath, growChance);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    @Override
    protected BlockState makeBottomState(BlockState state) {
        return (BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM);
    }

    @Override
    protected BlockState makeMiddleState(BlockState state) {
        return (BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE);
    }

    @Override
    protected BlockState makeTopState(BlockState state) {
        return (BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP);
    }

    public static class Growing
    extends BaseVineBlock {
        public Growing(BlockBehaviour.Properties properties, int maxGrowLength, int spaceBeneath, int growChance) {
            super(properties.randomTicks(), maxGrowLength, spaceBeneath, growChance);
        }

        public boolean isRandomlyTicking(BlockState state) {
            return state.getValue((Property)SHAPE) == BlockProperties.TripleShape.BOTTOM;
        }
    }
}

