/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.blocks.BaseTerrainBlock;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.betterx.wover.block.api.BlockProperties;
import org.jetbrains.annotations.Nullable;

public class TripleTerrainBlock
extends BaseTerrainBlock
implements RuntimeBlockModelProvider {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public TripleTerrainBlock(Block baseBlock) {
        super(baseBlock, baseBlock.defaultMapColor());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
    }

    public TripleTerrainBlock(Block baseBlock, MapColor color) {
        super(baseBlock, color);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction dir = ctx.getClickedFace();
        BlockProperties.TripleShape shape = dir == Direction.UP ? BlockProperties.TripleShape.BOTTOM : (dir == Direction.DOWN ? BlockProperties.TripleShape.TOP : BlockProperties.TripleShape.MIDDLE);
        return (BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)shape);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.getValue(SHAPE);
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            return super.useWithoutItem(state, world, pos, player, hit);
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.getValue(SHAPE);
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            super.randomTick(state, world, pos, random);
        } else if (random.nextInt(16) == 0) {
            boolean bottom = this.canStayBottom((LevelReader)world, pos);
            if (shape == BlockProperties.TripleShape.TOP) {
                if (!bottom) {
                    world.setBlockAndUpdate(pos, Blocks.END_STONE.defaultBlockState());
                }
            } else {
                boolean top;
                boolean bl = top = this.canStay(state, (LevelReader)world, pos) || this.isMiddle(world.getBlockState(pos.above()));
                if (!top && !bottom) {
                    world.setBlockAndUpdate(pos, Blocks.END_STONE.defaultBlockState());
                } else if (top && !bottom) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
                } else if (!top) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
                }
            }
        }
    }

    protected boolean canStayBottom(LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        if (this.isMiddle(blockState)) {
            return true;
        }
        if (blockState.getFluidState().getAmount() == 8) {
            return false;
        }
        return !blockState.isFaceSturdy((BlockGetter)world, blockPos, Direction.UP);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockModel getItemModel(ResourceLocation blockId) {
        return this.getBlockModel(blockId, this.defaultBlockState());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation blockId, BlockState blockState) {
        Optional<String> pattern;
        String path = blockId.getPath();
        if (this.isMiddle(blockState)) {
            ResourceLocation topId = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)(path + "_top"));
            pattern = PatternsHelper.createBlockSimple(topId);
        } else {
            HashMap textures = Maps.newHashMap();
            textures.put("%top%", "betterend:block/" + path + "_top");
            textures.put("%side%", "betterend:block/" + path + "_side");
            textures.put("%bottom%", "minecraft:block/end_stone");
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_TOP_SIDE_BOTTOM, textures);
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public UnbakedModel getModelVariant(ModelResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        boolean isMiddle = this.isMiddle(blockState);
        String middle = isMiddle ? "_middle" : "";
        ModelResourceLocation modelId = RuntimeBlockModelProvider.remapModelResourceLocation(stateId, blockState, middle);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        if (isMiddle) {
            ArrayList variants = Lists.newArrayList();
            for (BlockModelRotation rotation : BlockModelRotation.values()) {
                variants.add(new Variant(modelId.id(), rotation.getRotation(), false, 1));
            }
            return new MultiVariant((List)variants);
        }
        if (blockState.getValue(SHAPE) == BlockProperties.TripleShape.TOP) {
            return new MultiVariant((List)Lists.newArrayList((Object[])new Variant[]{new Variant(modelId.id(), BlockModelRotation.X180_Y0.getRotation(), false, 1), new Variant(modelId.id(), BlockModelRotation.X180_Y90.getRotation(), false, 1), new Variant(modelId.id(), BlockModelRotation.X180_Y180.getRotation(), false, 1), new Variant(modelId.id(), BlockModelRotation.X180_Y270.getRotation(), false, 1)}));
        }
        return ModelsHelper.createRandomTopModel(modelId.id());
    }

    protected boolean isMiddle(BlockState blockState) {
        return blockState.is((Block)this) && blockState.getValue(SHAPE) == BlockProperties.TripleShape.MIDDLE;
    }
}

