/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.client.models.UnbakedQuad;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class OBJBlockModel
implements UnbakedModel,
BakedModel {
    private static final Vector3f[] POSITIONS = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f()};
    protected final Map<Direction, List<UnbakedQuad>> quadsUnbakedMap = Maps.newEnumMap(Direction.class);
    protected final Map<Direction, List<BakedQuad>> quadsBakedMap = Maps.newEnumMap(Direction.class);
    protected final List<UnbakedQuad> quadsUnbaked = Lists.newArrayList();
    protected final List<BakedQuad> quadsBaked = Lists.newArrayList();
    protected TextureAtlasSprite[] sprites;
    protected ItemTransforms transforms;
    protected ItemOverrides overrides;
    protected List<Material> materials;
    protected boolean useCulling;
    protected boolean useShading;
    protected byte particleIndex;

    public OBJBlockModel(ResourceLocation location, Vector3f offset, boolean useCulling, boolean useShading, byte particleIndex, ResourceLocation ... textureIDs) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            this.quadsUnbakedMap.put(dir, Lists.newArrayList());
            this.quadsBakedMap.put(dir, Lists.newArrayList());
        }
        this.transforms = ItemTransforms.NO_TRANSFORMS;
        this.overrides = ItemOverrides.EMPTY;
        this.materials = new ArrayList<Material>(textureIDs.length);
        this.sprites = new TextureAtlasSprite[textureIDs.length];
        this.particleIndex = particleIndex;
        this.useCulling = useCulling;
        this.useShading = useShading;
        this.loadModel(location, offset, (byte)(textureIDs.length - 1));
        for (int i = 0; i < textureIDs.length; ++i) {
            this.materials.add(new Material(TextureAtlas.LOCATION_BLOCKS, textureIDs[i]));
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> function) {
    }

    @Nullable
    public BakedModel bake(ModelBaker modelBaker, Function<Material, TextureAtlasSprite> textureGetter, ModelState modelState) {
        for (int i = 0; i < this.sprites.length; ++i) {
            this.sprites[i] = textureGetter.apply(this.materials.get(i));
        }
        this.quadsBaked.clear();
        this.quadsUnbaked.forEach(quad -> this.quadsBaked.add(quad.bake(this.sprites, modelState)));
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            List<UnbakedQuad> unbaked = this.quadsUnbakedMap.get(dir);
            List<BakedQuad> baked = this.quadsBakedMap.get(dir);
            baked.clear();
            unbaked.forEach(quad -> baked.add(quad.bake(this.sprites, modelState)));
        }
        return this;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource random) {
        return direction == null ? this.quadsBaked : this.quadsBakedMap.get(direction);
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.sprites[this.particleIndex];
    }

    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    private Resource getResource(ResourceLocation location) {
        return Minecraft.getInstance().getResourceManager().getResource(location).orElse(null);
    }

    private void loadModel(ResourceLocation location, Vector3f offset, byte maxIndex) {
        Resource resource = this.getResource(location);
        if (resource == null) {
            return;
        }
        InputStream input = null;
        try {
            input = resource.open();
        }
        catch (IOException e) {
            BCLib.LOGGER.error("Unable to load Model", (Exception)e);
            throw new RuntimeException(e);
        }
        ArrayList<Float> vertecies = new ArrayList<Float>(12);
        ArrayList<Float> uvs = new ArrayList<Float>(8);
        ArrayList<Integer> vertexIndex = new ArrayList<Integer>(4);
        ArrayList<Integer> uvIndex = new ArrayList<Integer>(4);
        byte materialIndex = -1;
        try {
            String string;
            InputStreamReader streamReader = new InputStreamReader(input);
            BufferedReader reader = new BufferedReader(streamReader);
            while ((string = reader.readLine()) != null) {
                int i;
                if (string.startsWith("usemtl")) {
                    if ((materialIndex = (byte)((byte)(materialIndex + 1))) <= maxIndex) continue;
                    materialIndex = maxIndex;
                    continue;
                }
                if (string.startsWith("vt")) {
                    String[] uv = string.split(" ");
                    uvs.add(Float.valueOf(Float.parseFloat(uv[1])));
                    uvs.add(Float.valueOf(Float.parseFloat(uv[2])));
                    continue;
                }
                if (string.startsWith("v")) {
                    String[] vert = string.split(" ");
                    for (i = 1; i < 4; ++i) {
                        vertecies.add(Float.valueOf(Float.parseFloat(vert[i])));
                    }
                    continue;
                }
                if (!string.startsWith("f")) continue;
                String[] members = string.split(" ");
                if (members.length != 5) {
                    System.out.println("Only quads in OBJ are supported! Model [" + String.valueOf(location) + "] has n-gons or triangles!");
                    continue;
                }
                vertexIndex.clear();
                uvIndex.clear();
                for (i = 1; i < members.length; ++i) {
                    String member = members[i];
                    if (member.contains("/")) {
                        String[] sub = member.split("/");
                        vertexIndex.add(Integer.parseInt(sub[0]) - 1);
                        uvIndex.add(Integer.parseInt(sub[1]) - 1);
                        continue;
                    }
                    vertexIndex.add(Integer.parseInt(member) - 1);
                }
                boolean hasUV = !uvIndex.isEmpty();
                UnbakedQuad quad2 = new UnbakedQuad();
                for (int i2 = 0; i2 < 4; ++i2) {
                    int index = (Integer)vertexIndex.get(i2) * 3;
                    int quadIndex = i2 * 5;
                    quad2.addData(quadIndex++, ((Float)vertecies.get(index++)).floatValue() + offset.x());
                    quad2.addData(quadIndex++, ((Float)vertecies.get(index++)).floatValue() + offset.y());
                    quad2.addData(quadIndex++, ((Float)vertecies.get(index)).floatValue() + offset.z());
                    if (!hasUV) continue;
                    index = (Integer)uvIndex.get(i2) * 2;
                    quad2.addData(quadIndex++, ((Float)uvs.get(index++)).floatValue() * 16.0f);
                    quad2.addData(quadIndex, (1.0f - ((Float)uvs.get(index)).floatValue()) * 16.0f);
                }
                quad2.setSpriteIndex(materialIndex);
                if (this.useShading) {
                    Direction dir = this.getNormalDirection(quad2);
                    quad2.setDirection(dir);
                    quad2.setShading(true);
                }
                if (this.useCulling) {
                    Direction dir = this.getCullingDirection(quad2);
                    if (dir == null) {
                        this.quadsUnbaked.add(quad2);
                        continue;
                    }
                    this.quadsUnbakedMap.get(dir).add(quad2);
                    continue;
                }
                this.quadsUnbaked.add(quad2);
            }
            reader.close();
            streamReader.close();
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (materialIndex < 0) {
            this.quadsUnbaked.forEach(quad -> quad.setSpriteIndex(0));
            this.quadsUnbakedMap.values().forEach(list -> list.forEach(quad -> quad.setSpriteIndex(0)));
        }
    }

    private Direction getNormalDirection(UnbakedQuad quad) {
        Vector3f pos = quad.getPos(0, POSITIONS[0]);
        Vector3f dirA = quad.getPos(1, POSITIONS[1]);
        Vector3f dirB = quad.getPos(2, POSITIONS[2]);
        dirA.sub((Vector3fc)pos);
        dirB.sub((Vector3fc)pos);
        pos = MHelper.cross(dirA, dirB);
        return Direction.getNearest((float)pos.x(), (float)pos.y(), (float)pos.z());
    }

    @Nullable
    private Direction getCullingDirection(UnbakedQuad quad) {
        Direction dir = null;
        for (int i = 0; i < 4; ++i) {
            Vector3f pos = quad.getPos(i, POSITIONS[0]);
            if (pos.x() < 1.0f && pos.x() > 0.0f && pos.y() < 1.0f && pos.y() > 0.0f && pos.z() < 1.0f && pos.z() > 0.0f) {
                return null;
            }
            Direction newDir = Direction.getNearest((float)(pos.x() - 0.5f), (float)(pos.y() - 0.5f), (float)(pos.z() - 0.5f));
            if (dir == null) {
                dir = newDir;
                continue;
            }
            if (newDir == dir) continue;
            return null;
        }
        return dir;
    }
}

