/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.commands.PlaceCommandBuilder;
import org.betterx.bclib.util.BlocksHelper;

public class PlaceCommand {
    public static final String PLACE_COMMAND = "place";
    public static final String POOL = "pool";

    public static LiteralArgumentBuilder<CommandSourceStack> register(LiteralArgumentBuilder<CommandSourceStack> bnContext, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)PLACE_COMMAND).requires(commandSourceStack -> commandSourceStack.hasPermission(2));
        new PlaceCommandBuilder().register(commandBuildContext, (LiteralArgumentBuilder<CommandSourceStack>)command);
        return (LiteralArgumentBuilder)bnContext.then((ArgumentBuilder)command);
    }

    private static boolean isEmpty(Level level, BoundingBox bb) {
        for (int x = bb.minX(); x <= bb.maxX(); ++x) {
            for (int y = bb.minY(); y <= bb.maxY(); ++y) {
                for (int z = bb.minZ(); z <= bb.maxZ(); ++z) {
                    if (level.isEmptyBlock(new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void replaceAir(Level level, BoundingBox bb) {
        BlocksHelper.forAllInBounds(bb, bp -> {
            if (level.getBlockState(bp).is(Blocks.AIR)) {
                level.setBlock(bp, Blocks.STRUCTURE_VOID.defaultBlockState(), 3);
            }
        });
    }

    private static void removeLootTableSeed(Level level, BoundingBox bb) {
        BlocksHelper.forAllInBounds(bb, bp -> {
            BlockEntity patt0$temp = level.getBlockEntity(bp);
            if (patt0$temp instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity rnd = (RandomizableContainerBlockEntity)patt0$temp;
                rnd.setLootTable(rnd.getLootTable(), 0L);
            }
        });
    }

    static void fill(Level level, BoundingBox bb, BlockState blockState) {
        BlocksHelper.forAllInBounds(bb, bp -> level.setBlock(bp, blockState, 3));
    }

    static void fillStructureVoid(Level level, BoundingBox bb) {
        PlaceCommand.fill(level, bb, Blocks.STRUCTURE_VOID.defaultBlockState());
    }

    private static void outline(Level level, BoundingBox bb, BlockState outlineState) {
        BlocksHelper.forOutlineInBounds(bb, bp -> level.setBlock(bp, outlineState, 3));
    }

    private static BoundingBox adapt(BoundingBox bb, boolean border, boolean structureBlock) {
        if (border) {
            return bb.inflatedBy(1);
        }
        if (structureBlock) {
            return new BoundingBox(bb.minX(), bb.minY(), bb.minZ(), bb.maxX() + 1, bb.maxY() + 1, bb.maxZ() + 1);
        }
        return bb;
    }

    private static void createControlBlocks(CommandSourceStack stack, ResourceLocation location, BoundingBox bbNBT) {
        StructureBlockEntity entity;
        BlockPos structureBlockPos = new BlockPos(bbNBT.minX() - 1, bbNBT.minY() - 1, bbNBT.minZ() - 1);
        BlockPos commandBlockPos = new BlockPos(bbNBT.minX() - 1, bbNBT.minY() - 1, bbNBT.minZ());
        BlockPos buttonBlockPos = new BlockPos(bbNBT.minX() - 1, bbNBT.minY(), bbNBT.minZ());
        BlockState state = (BlockState)Blocks.STRUCTURE_BLOCK.defaultBlockState().setValue((Property)StructureBlock.MODE, (Comparable)StructureMode.SAVE);
        stack.getLevel().setBlock(structureBlockPos, state, 3);
        BlockEntity blockEntity = stack.getLevel().getBlockEntity(structureBlockPos);
        if (blockEntity instanceof StructureBlockEntity) {
            entity = (StructureBlockEntity)blockEntity;
            entity.setIgnoreEntities(false);
            entity.setShowAir(false);
            entity.setMirror(Mirror.NONE);
            entity.setRotation(Rotation.NONE);
            entity.setShowBoundingBox(true);
            entity.setStructureName(location);
            entity.setStructurePos(new BlockPos(1, 1, 1));
            entity.setStructureSize(new Vec3i(bbNBT.getXSpan(), bbNBT.getYSpan(), bbNBT.getZSpan()));
        }
        state = (BlockState)Blocks.COMMAND_BLOCK.defaultBlockState().setValue((Property)CommandBlock.FACING, (Comparable)Direction.DOWN);
        stack.getLevel().setBlock(commandBlockPos, state, 3);
        blockEntity = stack.getLevel().getBlockEntity(commandBlockPos);
        if (blockEntity instanceof CommandBlockEntity) {
            entity = (CommandBlockEntity)blockEntity;
            entity.setAutomatic(false);
            entity.setPowered(false);
            entity.onlyOpCanSetNbt();
            entity.getCommandBlock().shouldInformAdmins();
            entity.getCommandBlock().setCommand("fill ~1 ~1 ~ ~" + bbNBT.getXSpan() + " ~" + bbNBT.getYSpan() + " ~" + bbNBT.getZSpan() + " " + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)Blocks.STRUCTURE_VOID)) + " replace " + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)Blocks.AIR)));
        }
        state = (BlockState)((BlockState)Blocks.OAK_BUTTON.defaultBlockState().setValue((Property)ButtonBlock.FACING, (Comparable)Direction.EAST)).setValue((Property)ButtonBlock.FACE, (Comparable)AttachFace.FLOOR);
        stack.getLevel().setBlock(buttonBlockPos, state, 3);
    }

    static BoundingBox placeBlocks(CommandSourceStack stack, BlockPos pos, BlockPos searchDir, BlockInput blockInput, boolean structureBlock, boolean replaceAir, boolean preFillStructureVoid, ResourceLocation location, Function<BlockPos, BoundingBox> getBounds, BiConsumer<ServerLevel, BlockPos> generate) {
        BoundingBox bb;
        if (searchDir != null) {
            int tries;
            for (tries = 256; tries > 0 && !PlaceCommand.isEmpty((Level)stack.getLevel(), PlaceCommand.adapt(getBounds.apply(pos), blockInput != null, structureBlock)); --tries) {
                pos = pos.offset((Vec3i)searchDir);
            }
            if (tries <= 0) {
                stack.sendFailure((Component)Component.literal((String)"Failed to find free space").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                return null;
            }
        }
        if (structureBlock) {
            pos = pos.offset(1, 0, 1);
        }
        BoundingBox bbNBT = getBounds.apply(pos);
        if (blockInput != null) {
            bb = PlaceCommand.adapt(bbNBT, true, structureBlock);
            PlaceCommand.outline((Level)stack.getLevel(), bb, blockInput.getState());
            stack.sendSuccess(() -> Component.literal((String)("Placed border: " + bb.toString())).setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)), true);
        } else {
            bb = PlaceCommand.adapt(bbNBT, false, structureBlock);
        }
        if (preFillStructureVoid) {
            PlaceCommand.replaceAir((Level)stack.getLevel(), bb);
        }
        generate.accept(stack.getLevel(), pos);
        if (replaceAir) {
            PlaceCommand.replaceAir((Level)stack.getLevel(), bbNBT);
        }
        PlaceCommand.removeLootTableSeed((Level)stack.getLevel(), bbNBT);
        stack.sendSuccess(() -> Component.literal((String)("Placed NBT: " + bbNBT.toString())).setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)), true);
        if (structureBlock) {
            PlaceCommand.createControlBlocks(stack, location, bbNBT);
        }
        return bb;
    }

    public static BlockState setJigsawOrientation(boolean rollable, Player player, BlockPos pos, BlockState state) {
        int deltaY = player.getBlockY() - pos.getY();
        state = deltaY < 2 && deltaY > -2 && rollable ? (BlockState)state.setValue((Property)JigsawBlock.ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)player.getDirection().getOpposite(), (Direction)Direction.UP)) : (deltaY < 0 ? (BlockState)state.setValue((Property)JigsawBlock.ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)Direction.DOWN, (Direction)player.getDirection().getOpposite())) : (BlockState)state.setValue((Property)JigsawBlock.ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)Direction.UP, (Direction)player.getDirection().getOpposite())));
        return state;
    }
}

