/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ConnectorArgument
extends ResourceLocationArgument {
    private static final Collection<String> EXAMPLES = Arrays.asList("-:building_entrance", "-:bottom", "-:street");

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ResourceLocation pool = null;
        try {
            pool = ((ResourceKey)context.getArgument("pool", ResourceKey.class)).location();
        }
        catch (Throwable t) {
            pool = ResourceLocation.fromNamespaceAndPath((String)"-", (String)"");
        }
        return SharedSuggestionProvider.suggest(this.getStrings(pool.getNamespace(), List.of("bottom", "building_entrance", "street")), (SuggestionsBuilder)builder);
    }

    @NotNull
    private List<String> getStrings(String namespace, List<String> input) {
        return input.stream().map(s -> namespace + ":" + s).toList();
    }

    public static ConnectorArgument id() {
        return new ConnectorArgument();
    }
}

