/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import org.betterx.wover.core.api.ModCore;

public final class BCLWoodTypeWrapper {
    public final ResourceLocation id;
    public final WoodType type;
    public final MapColor color;
    public final boolean flammable;

    protected BCLWoodTypeWrapper(ResourceLocation id, WoodType type, MapColor color, boolean flammable) {
        this.id = id;
        this.type = type;
        this.color = color;
        this.flammable = flammable;
    }

    public static Builder create(ModCore modCore, String string) {
        return new Builder(modCore.mk(string));
    }

    public static Builder create(ResourceLocation id) {
        return new Builder(id);
    }

    public BlockSetType setType() {
        return this.type.setType();
    }

    public ResourceLocation id() {
        return this.id;
    }

    public WoodType type() {
        return this.type;
    }

    public MapColor color() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BCLWoodTypeWrapper that = (BCLWoodTypeWrapper)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.color, that.color);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.color);
    }

    public String toString() {
        return "BCLWoodTypeWrapper[id=" + String.valueOf(this.id) + ", type=" + String.valueOf(this.type) + ", color=" + String.valueOf(this.color) + "]";
    }

    private static BlockSetType registerBlockSetType(BlockSetType type) {
        try {
            for (Method method : BlockSetType.class.getDeclaredMethods()) {
                if (!method.getName().equals("register") || method.getParameterCount() != 1) continue;
                method.setAccessible(true);
                return (BlockSetType)method.invoke(null, type);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to register BlockSetType " + String.valueOf(type), e);
        }
        return type;
    }

    private static BlockSetType createBlockSetType(ResourceLocation id) {
        try {
            if (BlockSetType.class.isRecord()) {
                RecordComponent[] components = BlockSetType.class.getRecordComponents();
                Object[] args = new Object[components.length];
                Class[] types = new Class[components.length];
                for (int i = 0; i < components.length; ++i) {
                    RecordComponent component = components[i];
                    types[i] = component.getType();
                    args[i] = "name".equals(component.getName()) ? id.getPath() : component.getAccessor().invoke((Object)BlockSetType.OAK, new Object[0]);
                }
                Constructor ctor = BlockSetType.class.getDeclaredConstructor(types);
                ctor.setAccessible(true);
                return (BlockSetType)ctor.newInstance(args);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create BlockSetType " + String.valueOf(id), e);
        }
        throw new IllegalStateException("Unsupported BlockSetType layout for " + String.valueOf(id));
    }

    private static WoodType registerWoodType(WoodType type) {
        return WoodType.register((WoodType)type);
    }

    private static WoodType createWoodType(ResourceLocation id, BlockSetType setType) {
        try {
            for (Constructor<?> ctor : WoodType.class.getDeclaredConstructors()) {
                Class<?>[] params = ctor.getParameterTypes();
                Object[] args = new Object[params.length];
                boolean matched = true;
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] == String.class) {
                        args[i] = id.getPath();
                        continue;
                    }
                    if (params[i] == ResourceLocation.class) {
                        args[i] = id;
                        continue;
                    }
                    if (params[i] == BlockSetType.class) {
                        args[i] = setType;
                        continue;
                    }
                    matched = false;
                    break;
                }
                if (!matched) continue;
                ctor.setAccessible(true);
                return (WoodType)ctor.newInstance(args);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create WoodType " + String.valueOf(id), e);
        }
        throw new IllegalStateException("Unsupported WoodType layout for " + String.valueOf(id));
    }

    public static class Builder {
        private final ResourceLocation id;
        private BlockSetType setType;
        private MapColor color;
        private boolean flammable;

        public Builder(ResourceLocation id) {
            this.id = id;
            this.color = MapColor.WOOD;
            this.flammable = true;
        }

        public Builder setBlockSetType(BlockSetType setType) {
            this.setType = setType;
            return this;
        }

        public Builder setColor(MapColor color) {
            this.color = color;
            return this;
        }

        public Builder setFlammable(boolean flammable) {
            this.flammable = flammable;
            return this;
        }

        public BCLWoodTypeWrapper build() {
            if (this.setType == null) {
                this.setType = BCLWoodTypeWrapper.registerBlockSetType(BCLWoodTypeWrapper.createBlockSetType(this.id));
            }
            WoodType type = BCLWoodTypeWrapper.registerWoodType(BCLWoodTypeWrapper.createWoodType(this.id, this.setType));
            return new BCLWoodTypeWrapper(this.id, type, this.color, this.flammable);
        }
    }
}

