/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials.set.stone;

import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.blocks.BaseWallBlock;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.StoneComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.betterx.bclib.complexmaterials.set.common.AbstractWall;
import org.betterx.bclib.complexmaterials.set.stone.StoneSlots;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Wall
extends AbstractWall<StoneComplexMaterial> {
    private final MaterialSlot<StoneComplexMaterial> base;

    public Wall() {
        this.base = StoneSlots.SOURCE;
    }

    public Wall(MaterialSlot<StoneComplexMaterial> base) {
        super(base.suffix);
        this.base = base;
    }

    @Override
    @NotNull
    protected Block createBlock(StoneComplexMaterial parentMaterial, BlockBehaviour.Properties settings) {
        return new BaseWallBlock.Stone(parentMaterial.getBlock(this.getSourceBlockSlot()));
    }

    @Override
    @Nullable
    protected void makeRecipe(RecipeOutput context, ComplexMaterial parentMaterial, ResourceLocation id) {
        super.makeRecipe(context, parentMaterial, id);
        RecipeBuilder.stonecutting((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("stonecutter_" + id.getPath())), (ItemLike)parentMaterial.getBlock(this.suffix)).input((ItemLike)parentMaterial.getBlock(this.getSourceBlockSlot())).outputCount(1).group("wall").build(context);
    }

    @Override
    @Nullable
    protected MaterialSlot<StoneComplexMaterial> getSourceBlockSlot() {
        return this.base;
    }
}

