/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.interfaces;

import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.jetbrains.annotations.Nullable;

public interface RuntimeBlockModelProvider
extends ItemModelProvider {
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        Optional<String> pattern = PatternsHelper.createBlockSimple(resourceLocation);
        return ModelsHelper.fromPattern(pattern);
    }

    public static ModelResourceLocation remapModelResourceLocation(ModelResourceLocation stateId, BlockState blockState) {
        return RuntimeBlockModelProvider.remapModelResourceLocation(stateId, blockState, "");
    }

    public static ModelResourceLocation remapModelResourceLocation(ModelResourceLocation stateId, BlockState blockState, String pathAddOn) {
        return BlockModelShaper.stateToModelLocation((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)stateId.id().getNamespace(), (String)("block/" + stateId.id().getPath() + pathAddOn)), (BlockState)blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public UnbakedModel getModelVariant(ModelResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        ModelResourceLocation modelId = RuntimeBlockModelProvider.remapModelResourceLocation(stateId, blockState);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createBlockSimple(modelId.id());
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void registerBlockModel(ModelResourceLocation stateId, ModelResourceLocation modelId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        if (!modelCache.containsKey(modelId.id())) {
            BlockModel model = this.getBlockModel(stateId.id(), blockState);
            if (model != null) {
                model.name = modelId.toString();
                modelCache.put(modelId.id(), (UnbakedModel)model);
            } else {
                BCLib.LOGGER.warn("Error loading model: {}", new Object[]{modelId});
            }
        }
    }
}

