/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.interfaces;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.interfaces.SurvivesOnSpecialGround;

public interface SurvivesOnTags
extends SurvivesOnSpecialGround {
    public List<TagKey<Block>> getSurvivableTags();

    @Override
    default public String getSurvivableBlocksString() {
        return this.getSurvivableTags().stream().map(tag -> BuiltInRegistries.BLOCK.getTag(tag)).filter(named -> named.isPresent()).map(named -> (HolderSet.Named)named.get()).flatMap(named -> named.stream()).filter(block -> block != Blocks.AIR && block != null).map(block -> {
            ItemStack stack = new ItemStack((ItemLike)block.value());
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                return stack.getHoverName().getString();
            }
            return ((Block)block.value()).getName().getString();
        }).sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
    }

    @Override
    default public boolean isSurvivable(BlockState state) {
        return this.getSurvivableTags().stream().anyMatch(tag -> state.is(tag));
    }
}

