/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items;

import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blocks.BaseAnvilBlock;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.betterx.bclib.util.BCLDataComponents;

public class BaseAnvilItem
extends BlockItem
implements ItemModelProvider {
    public static final String DESTRUCTION = "destruction";

    public BaseAnvilItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected BlockState getPlacementState(BlockPlaceContext blockPlaceContext) {
        int destruction;
        BlockState blockState = super.getPlacementState(blockPlaceContext);
        ItemStack stack = blockPlaceContext.getItemInHand();
        CustomData anvilData = (CustomData)stack.getOrDefault(BCLDataComponents.ANVIL_ENTITY_DATA, (Object)CustomData.EMPTY);
        int n = destruction = anvilData.contains(DESTRUCTION) ? anvilData.getUnsafe().getInt(DESTRUCTION) : 0;
        if (blockState != null) {
            BaseAnvilBlock block = (BaseAnvilBlock)blockState.getBlock();
            IntegerProperty durabilityProp = block.getDurabilityProp();
            if (destruction == 0) {
                blockState = (BlockState)((BlockState)blockState.setValue((Property)durabilityProp, (Comparable)Integer.valueOf(0))).setValue((Property)BaseAnvilBlock.DESTRUCTION, (Comparable)Integer.valueOf(0));
            } else {
                int destructionValue = destruction / block.getMaxDurability();
                int durabilityValue = destruction - destructionValue * block.getMaxDurability();
                blockState = (BlockState)((BlockState)blockState.setValue((Property)durabilityProp, (Comparable)Integer.valueOf(durabilityValue))).setValue((Property)BaseAnvilBlock.DESTRUCTION, (Comparable)Integer.valueOf(destructionValue));
            }
        }
        return blockState;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        CustomData anvilData = (CustomData)itemStack.getOrDefault(BCLDataComponents.ANVIL_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!anvilData.contains(DESTRUCTION)) {
            return;
        }
        int destruction = anvilData.getUnsafe().getInt(DESTRUCTION);
        if (destruction > 0) {
            BaseAnvilBlock block = (BaseAnvilBlock)((BaseAnvilItem)itemStack.getItem()).getBlock();
            int maxValue = block.getMaxDurability() * 3;
            float damage = maxValue - destruction;
            String percents = String.format(Locale.ROOT, "%.0f%%", Float.valueOf(damage));
            list.add((Component)Component.translatable((String)"message.bclib.anvil_damage").append(": " + percents));
        }
    }
}

