/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items.elytra;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.extensions.IItemExtension;
import org.betterx.bclib.items.elytra.BCLElytraUtils;

public interface BCLElytraItem
extends IItemExtension {
    public ResourceLocation getModelTexture();

    public double getMovementFactor();

    default public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ElytraItem.isFlyEnabled((ItemStack)stack);
    }

    default public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        this.doVanillaElytraTick(entity, stack);
        return ElytraItem.isFlyEnabled((ItemStack)stack);
    }

    default public void doVanillaElytraTick(LivingEntity entity, ItemStack chestStack) {
        BCLElytraItem.vanillaElytraTick(entity, chestStack);
    }

    public static void vanillaElytraTick(LivingEntity entity, ItemStack chestStack) {
        int nextRoll = entity.getFallFlyingTicks() + 1;
        if (!entity.level().isClientSide && nextRoll % 10 == 0) {
            if (nextRoll / 10 % 2 == 0) {
                BCLElytraUtils.onBreak.accept(entity, chestStack);
                return;
            }
            entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
        }
    }
}

