/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common.elytra;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.items.elytra.BCLElytraItem;
import org.betterx.bclib.items.elytra.BCLElytraUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LivingEntity.class}, priority=199)
public abstract class LivingEntityMixin {
    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @ModifyVariable(method={"travel"}, at=@At(value="HEAD"), argsOnly=true, require=0)
    private Vec3 bclib_adjustTravelInput(Vec3 moveDelta) {
        Item item;
        ItemStack itemStack;
        LivingEntity self = (LivingEntity)this;
        if (!self.isFallFlying()) {
            return moveDelta;
        }
        ItemStack itemStack2 = itemStack = BCLElytraUtils.slotProvider == null ? this.getItemBySlot(EquipmentSlot.CHEST) : BCLElytraUtils.slotProvider.getElytra(self, this::getItemBySlot);
        if (itemStack != null && (item = itemStack.getItem()) instanceof BCLElytraItem) {
            BCLElytraItem elytra = (BCLElytraItem)item;
            double movementFactor = elytra.getMovementFactor();
            return moveDelta.multiply(movementFactor, 1.0, movementFactor);
        }
        return moveDelta;
    }
}

