/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.bclib.BCLib;
import org.betterx.betternether.Patcher;
import org.betterx.betternether.advancements.BNCriterion;
import org.betterx.betternether.commands.CommandRegistry;
import org.betterx.betternether.config.Config;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.loot.BNLoot;
import org.betterx.betternether.registry.BlockEntitiesRegistry;
import org.betterx.betternether.registry.BrewingRegistry;
import org.betterx.betternether.registry.NetherBiomes;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherEnchantments;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.registry.NetherParticles;
import org.betterx.betternether.registry.NetherPoiTypes;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.SoundsRegistry;
import org.betterx.betternether.registry.features.configured.NetherVegetation;
import org.betterx.betternether.tab.BECreativeTabs;
import org.betterx.betternether.world.BNWorldGenerator;
import org.betterx.datagen.betternether.BetterNetherDatagen;
import org.betterx.wover.block.api.BlockRegistry;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemRegistry;
import org.betterx.wover.state.api.WorldConfig;

@Mod(value="betternether")
public class BetterNether {
    public static final String MOD_ID = "betternether";
    public static final ModCore C = ModCore.create((String)"betternether");
    public static final ModCore VANILLA_HAMMERS = ModCore.create((String)"vanilla-hammers");
    public static final ModCore VANILLA_EXCAVATORS = ModCore.create((String)"vanillaexcavators");
    public static final ResourceLocation VANILLA_HAMMERS_PACK = C.addDatapack(VANILLA_HAMMERS);
    public static final ResourceLocation VANILLA_EXCAVATORS_PACK = C.addDatapack(VANILLA_EXCAVATORS);
    private static boolean lavafallParticles = true;
    private static float fogStart = 0.05f;
    private static float fogEnd = 0.5f;

    private void onDatagen() {
    }

    public BetterNether(IEventBus modBus) {
        C.registerDatapackListener(modBus);
        NetherBlocks.getBlockRegistry();
        NetherItems.getItemRegistry();
        modBus.addListener(SoundsRegistry::register);
        modBus.addListener(NetherEnchantments::register);
        modBus.addListener(RegisterEvent.class, NetherEntities::onRegister);
        modBus.addListener(RegisterEvent.class, NetherParticles::onRegister);
        modBus.addListener(RegisterEvent.class, NetherPoiTypes::onRegister);
        modBus.addListener(RegisterEvent.class, NetherFeatures::onRegister);
        modBus.addListener(RegisterEvent.class, BlockEntitiesRegistry::register);
        modBus.addListener(RegisterEvent.class, this::ensureBlocksLoaded);
        modBus.addListener(RegisterEvent.class, this::ensureItemsLoaded);
        modBus.addListener(RegisterEvent.class, BNCriterion::onRegister);
        modBus.addListener(RegisterEvent.class, BECreativeTabs::onRegister);
        BlockRegistry.hook((IEventBus)modBus);
        ItemRegistry.hook((IEventBus)modBus);
        if (ModCore.isDatagen()) {
            BetterNetherDatagen datagen = new BetterNetherDatagen();
            modBus.addListener(arg_0 -> ((BetterNetherDatagen)datagen).onGatherData(arg_0));
        }
        this.initialize();
    }

    private void ensureBlocksLoaded(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.BLOCK)) {
            try {
                Class.forName("org.betterx.betternether.registry.NetherBlocks");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void ensureItemsLoaded(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            try {
                Class.forName("org.betterx.betternether.registry.NetherItems");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void initialize() {
        BetterNether.C.log.info("=^..^=    BetterNether Neoforged for 1.21    =^..^=");
        this.initOptions();
        SoundsRegistry.ensureStaticallyLoaded();
        NetherEnchantments.ensureStaticallyLoaded();
        BlockEntitiesRegistry.register();
        NetherEntities.register();
        BNWorldGenerator.onModInit();
        NetherStructures.register();
        NetherBiomes.register();
        BrewingRegistry.register();
        CommandRegistry.register();
        Config.save();
        NetherTags.register();
        BNLoot.register();
        NetherVegetation.registerLifecycleHook();
        Configs.saveConfigs();
        WorldConfig.registerMod((ModCore)C);
        Patcher.register();
        if (BCLib.isDatagen()) {
            this.onDatagen();
        }
    }

    private void initOptions() {
        lavafallParticles = (Boolean)Configs.CLIENT.lavafallParticles.get();
        float density = ((Float)Configs.CLIENT.fogDensity.get()).floatValue();
        BetterNether.changeFogDensity(density);
    }

    public static boolean hasLavafallParticles() {
        return lavafallParticles;
    }

    public static void changeFogDensity(float density) {
        fogStart = -0.45f * density + 0.5f;
        fogEnd = -0.5f * density + 1.0f;
    }

    public static float getFogStart() {
        return fogStart;
    }

    public static float getFogEnd() {
        return fogEnd;
    }
}

