/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.advancements.BNCriterion;

public class ConvertByLightningTrigger
extends SimpleCriterionTrigger<TriggerInstance>
implements BNCriterion.TriggerWithID<TriggerInstance> {
    public static final ResourceLocation ID = BetterNether.C.id("convert_by_lightning");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public void trigger(ServerPlayer serverPlayer, ItemLike item) {
        this.trigger(serverPlayer, triggerInstance -> triggerInstance.matches(new ItemStack(item)));
    }

    public Criterion<TriggerInstance> match(ItemLike item) {
        return BNCriterion.CONVERT_BY_LIGHTNING.createCriterion((CriterionTriggerInstance)new TriggerInstance(ItemPredicate.Builder.item().of(new ItemLike[]{item}).build()));
    }

    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public static class TriggerInstance
    implements SimpleCriterionTrigger.SimpleInstance {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemPredicate.CODEC.fieldOf("item").forGetter(triggerInstance -> triggerInstance.item)).apply((Applicative)instance, TriggerInstance::new));
        private final ItemPredicate item;

        public TriggerInstance(ItemPredicate itemPredicate) {
            this.item = itemPredicate;
        }

        public boolean matches(ItemStack itemStack) {
            return this.item.test(itemStack);
        }

        public void validate(CriterionValidator criterionValidator) {
            super.validate(criterionValidator);
        }

        public Optional<ContextAwarePredicate> player() {
            return Optional.empty();
        }
    }
}

