/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blockentities;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockChestOfDrawers;
import org.betterx.betternether.registry.BlockEntitiesRegistry;

public class BlockEntityChestOfDrawers
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private int watchers = 0;

    public BlockEntityChestOfDrawers(BlockPos pos, BlockState state) {
        super(BlockEntitiesRegistry.CHEST_OF_DRAWERS, pos, state);
    }

    public int getContainerSize() {
        return 27;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.chest_of_drawers", (Object[])new Object[0]);
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return ChestMenu.threeRows((int)syncId, (Inventory)playerInventory, (Container)this);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        }
    }

    public void onInvOpen(Player player) {
        if (!player.isSpectator()) {
            if (this.watchers < 0) {
                this.watchers = 0;
            }
            if (this.watchers == 0) {
                this.playSound(this.getBlockState(), SoundEvents.BARREL_OPEN);
            }
            ++this.watchers;
            this.onInvOpenOrClose();
        }
    }

    public void stopOpen(Player player) {
        if (!player.isSpectator()) {
            --this.watchers;
            this.onInvOpenOrClose();
        }
    }

    protected void onInvOpenOrClose() {
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof BlockChestOfDrawers && !this.level.isClientSide) {
            if (this.watchers > 0 && !((Boolean)state.getValue((Property)BlockChestOfDrawers.OPEN)).booleanValue()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)this.level, this.worldPosition, (BlockState)state.setValue((Property)BlockChestOfDrawers.OPEN, (Comparable)Boolean.valueOf(true)));
            } else if (this.watchers == 0 && ((Boolean)state.getValue((Property)BlockChestOfDrawers.OPEN)).booleanValue()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)this.level, this.worldPosition, (BlockState)state.setValue((Property)BlockChestOfDrawers.OPEN, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private void playSound(BlockState blockState, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)blockState.getValue((Property)BlockChestOfDrawers.FACING)).getNormal();
        double d = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double e = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double f = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void addItemsToList(List<ItemStack> items) {
        for (ItemStack item : this.inventory) {
            if (item == null) continue;
            items.add(item);
        }
    }
}

