/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.betternether.blockentities.BNBrewingStandBlockEntity;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.client.IRenderTypeable;
import org.betterx.betternether.registry.BlockEntitiesRegistry;

public class BNBrewingStand
extends BrewingStandBlock
implements IRenderTypeable,
BehaviourStone {
    public BNBrewingStand() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_BRICKS).strength(0.5f, 0.5f).lightLevel(state -> 1).noOcclusion());
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : BNBrewingStand.createTickerHelper(type, BlockEntitiesRegistry.NETHER_BREWING_STAND, BNBrewingStandBlockEntity::tick);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BNBrewingStandBlockEntity(blockPos, blockState);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BNBrewingStandBlockEntity) {
            player.openMenu((MenuProvider)((BNBrewingStandBlockEntity)blockEntity));
            player.awardStat(Stats.INTERACT_WITH_BREWINGSTAND);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean notify) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof BNBrewingStandBlockEntity) {
                BNBrewingStandBlockEntity bn = (BNBrewingStandBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)bn);
            }
            super.onRemove(state, world, pos, newState, notify);
        }
    }

    @Override
    public BNRenderLayer getRenderLayer() {
        return BNRenderLayer.CUTOUT;
    }
}

