/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourGlass;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.client.IRenderTypeable;

public abstract class BNPane
extends IronBarsBlock
implements IRenderTypeable {
    private final boolean dropSelf;

    protected BNPane(Block block, boolean dropSelf) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block).strength(0.3f, 0.3f).noOcclusion());
        this.dropSelf = dropSelf;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (this.dropSelf) {
            return Collections.singletonList(new ItemStack((ItemLike)this.asItem()));
        }
        return super.getDrops(state, builder);
    }

    @Override
    public BNRenderLayer getRenderLayer() {
        return BNRenderLayer.TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState state, BlockState neighbor, Direction facing) {
        if (neighbor.getBlock() == this) {
            if (!facing.getAxis().isHorizontal()) {
                return false;
            }
            if (((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(facing))).booleanValue() && ((Boolean)neighbor.getValue((Property)PROPERTY_BY_DIRECTION.get(facing.getOpposite()))).booleanValue()) {
                return true;
            }
        }
        return super.skipRendering(state, neighbor, facing);
    }

    public static BNPane from(Block source, boolean dropSelf) {
        return (BNPane)BehaviourHelper.from((Block)source, s -> new Wood((Block)s, dropSelf), s -> new Stone((Block)s, dropSelf), s -> new Metal((Block)s, dropSelf), s -> new Obsidian((Block)s, dropSelf), s -> new Glass((Block)s, dropSelf));
    }

    public static class Glass
    extends BNPane
    implements BehaviourGlass {
        public Glass(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }

    public static class Obsidian
    extends BNPane
    implements BehaviourObsidian {
        public Obsidian(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }

    public static class Metal
    extends BNPane
    implements BehaviourMetal {
        public Metal(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }

    public static class Stone
    extends BNPane
    implements BehaviourStone {
        public Stone(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }

    public static class Wood
    extends BNPane
    implements BehaviourWood {
        public Wood(Block block, boolean dropSelf) {
            super(block, dropSelf);
        }
    }
}

